/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.lits;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaEditStep;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.Direction;
import pencilbox.lits.Area;
import pencilbox.lits.Wall;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int WHITE = -1;
    static final int BLACK = -2;
    static final int UNKNOWN = 0;
    private List<Area> areaList;
    private Area[][] area;
    private int[][] state;
    private List<Wall> wallList;
    private Wall[][] wall;
    private Wall initializingWall;

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList<Area>();
        this.wall = new Wall[this.rows()][this.cols()];
        this.wallList = new LinkedList<Wall>();
    }

    @Override
    public void clearBoard() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.setState(p, 0);
            ++n2;
        }
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -1) {
                this.changeState(p, 0);
            }
            ++n2;
        }
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address p) {
        return this.getState(p.r(), p.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address p, int st) {
        this.setState(p.r(), p.c(), st);
    }

    public boolean isBlack(int r, int c) {
        return this.isOn(r, c) && this.state[r][c] == -2;
    }

    public boolean isBlack(Address p) {
        return this.isOn(p) && this.getState(p) == -2;
    }

    public Wall getWall(Address p) {
        return this.wall[p.r()][p.c()];
    }

    public void setWall(Address p, Wall a) {
        this.wall[p.r()][p.c()] = a;
    }

    public Area getArea(int r, int c) {
        if (!this.isOn(r, c)) {
            return null;
        }
        return this.area[r][c];
    }

    public Area getArea(Address p) {
        return this.getArea(p.r(), p.c());
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void setArea(Address p, Area a) {
        this.setArea(p.r(), p.c(), a);
    }

    public void changeState(Address p, int st) {
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, prev, st));
        }
        this.setState(p, st);
        Area a = this.getArea(p);
        if (a != null) {
            if (prev == -2) {
                a.getTetromino().remove(p);
            }
            if (st == -2) {
                a.getTetromino().add(p);
            }
        }
    }

    public void addArea(Area newArea) {
        for (Address p : newArea) {
            this.area[p.r()][p.c()] = newArea;
        }
        this.areaList.add(newArea);
    }

    public void removeWholeArea(Area oldArea) {
        Address[] cells;
        Address[] addressArray = cells = oldArea.toArray(new Address[0]);
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.removeCellFromArea(p, oldArea);
            ++n2;
        }
    }

    public void addCellToArea(Address p, Area a) {
        if (this.isRecordUndo()) {
            Address p0 = Address.NOWHERE;
            if (a.size() > 0) {
                p0 = a.getTopCell(Address.NOWHERE);
            }
            this.fireUndoableEditUpdate(new AreaEditStep(p, p0, 1));
        }
        if (a.isEmpty()) {
            this.areaList.add(a);
        }
        this.setArea(p, a);
        a.add(p);
        if (this.getState(p) == -2) {
            a.getTetromino().add(p);
        }
    }

    public void removeCellFromArea(Address p, Area a) {
        if (this.isRecordUndo()) {
            Address p0 = Address.NOWHERE;
            if (a.size() > 1) {
                p0 = a.getTopCell(p);
            }
            this.fireUndoableEditUpdate(new AreaEditStep(p, p0, 0));
        }
        this.setArea(p, null);
        a.remove(p);
        if (this.getState(p) == -2) {
            a.getTetromino().remove(p);
        }
        if (a.isEmpty()) {
            this.areaList.remove(a);
        }
    }

    void addCell(Address p0, Address p) {
        if (Address.NOWHERE.equals(p0)) {
            Area a = new Area();
            this.addCellToArea(p, a);
        } else {
            Area a = this.getArea(p0);
            if (a != null) {
                this.addCellToArea(p, a);
            }
        }
    }

    void removeCell(Address p) {
        Area a = this.getArea(p);
        if (a != null) {
            this.removeCellFromArea(p, a);
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeState(s.getPos(), s.getBefore());
        } else if (step instanceof AreaEditStep) {
            AreaEditStep s = (AreaEditStep)step;
            if (s.getOperation() == 1) {
                this.removeCell(s.getPos());
            } else if (s.getOperation() == 0) {
                this.addCell(s.getP0(), s.getPos());
            }
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeState(s.getPos(), s.getAfter());
        } else if (step instanceof AreaEditStep) {
            AreaEditStep s = (AreaEditStep)step;
            if (s.getOperation() == 1) {
                this.addCell(s.getP0(), s.getPos());
            } else if (s.getOperation() == 0) {
                this.removeCell(s.getPos());
            }
        }
    }

    List<Area> getAreaList() {
        return this.areaList;
    }

    int[][] getState() {
        return this.state;
    }

    @Override
    public void initBoard() {
        this.initTetrominos();
    }

    boolean is2x2Block(Address p) {
        if (this.isBlack(p)) {
            int d = 0;
            while (d < 4) {
                Address p3;
                Address p2;
                Address p1 = Address.nextCell(p, d);
                if (this.isBlack(p1) && this.isBlack(p2 = Address.nextCell(p1, (d + 1) % 4)) && this.isBlack(p3 = Address.nextCell(p2, (d + 2) % 4))) {
                    return true;
                }
                ++d;
            }
        }
        return false;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        if (this.areaList.size() == 0) {
            result |= 1;
        }
        if (((result |= this.checkTetrominos()) & 8) == 0) {
            result |= this.checkAdjacentCongruousTetrominos();
        }
        result |= this.checkConnection();
        return result |= this.check2x2s();
    }

    public int checkTetrominos() {
        int result = 0;
        int[] count = new int[6];
        for (Area a : this.areaList) {
            int n = a.getTetrominoType();
            count[n] = count[n] + 1;
        }
        if (count[0] > 0) {
            result = 8;
        }
        return result;
    }

    public void initTetrominos() {
        for (Area a : this.areaList) {
            a.getTetromino().clear();
        }
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getArea(p) != null && this.getState(p) == -2) {
                this.getArea(p).getTetromino().add(p);
            }
            ++n2;
        }
    }

    private int checkAdjacentCongruousTetrominos() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getArea(p) != null && this.getState(p) == -2) {
                int[] nArray = Direction.DN_RT;
                int n3 = Direction.DN_RT.length;
                int n4 = 0;
                while (n4 < n3) {
                    int d = nArray[n4];
                    Address p1 = Address.nextCell(p, d);
                    if (this.getArea(p1) != null && this.getArea(p) != this.getArea(p1) && this.getState(p1) == -2 && this.getArea(p).getTetrominoType() == this.getArea(p1).getTetrominoType()) {
                        result = 16;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    private int checkConnection() {
        ArrayUtil.initArrayObject2(this.wall, null);
        this.wallList.clear();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -2 && this.getWall(p) == null) {
                if (this.wallList.size() > 0) {
                    return 32;
                }
                this.initWall(p);
            }
            ++n2;
        }
        return 0;
    }

    private void initWall(Address p) {
        this.initializingWall = new Wall();
        this.initWall1(p);
        this.wallList.add(this.initializingWall);
    }

    private boolean initWall1(Address p) {
        if (!this.isOn(p)) {
            return false;
        }
        if (!this.isBlack(p)) {
            return false;
        }
        if (this.getWall(p) == this.initializingWall) {
            return false;
        }
        this.initializingWall.add(p);
        this.setWall(p, this.initializingWall);
        int d = 0;
        while (d < 4) {
            this.initWall1(Address.nextCell(p, d));
            ++d;
        }
        return true;
    }

    private int check2x2s() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.is2x2Block(p)) {
                result |= 0x40;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("lits.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            // empty if block
        }
        if ((result & 4) == 4) {
            // empty if block
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("lits.AnswerCheckMessage2"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("lits.AnswerCheckMessage3"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("lits.AnswerCheckMessage4"));
        }
        if ((result & 0x40) == 64) {
            message.append(Messages.getString("lits.AnswerCheckMessage5"));
        }
        return message.toString();
    }
}

