/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BorderEditStep;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.SideAddress;
import pencilbox.resource.Messages;
import pencilbox.slalom.Link;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UNKNOWN = 0;
    static final int LINE = 1;
    static final int NOLINE = -1;
    static final int NONUMBER = -1;
    static final int OUTER = -9;
    static final int UNDECIDED_NUMBER = 5;
    private int[][] number;
    private int[][][] state;
    private List<Link> linkList;
    private Link[][][] link;
    private Link initializingLink;

    @Override
    protected void setup() {
        super.setup();
        this.number = new int[this.rows() - 1][this.cols() - 1];
        ArrayUtil.initArrayInt2(this.number, -1);
        this.state = new int[2][][];
        this.state[0] = new int[this.rows()][this.cols() - 1];
        this.state[1] = new int[this.rows() - 1][this.cols()];
        this.linkList = new LinkedList<Link>();
        this.link = new Link[2][][];
        this.link[0] = new Link[this.rows()][this.cols() - 1];
        this.link[1] = new Link[this.rows() - 1][this.cols()];
    }

    public boolean isNumberOn(int r, int c) {
        return r >= 0 && r < this.rows() - 1 && c >= 0 && c < this.cols() - 1;
    }

    public boolean isNumberOn(Address pos) {
        return this.isNumberOn(pos.r(), pos.c());
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public boolean isNumber(int r, int c) {
        return this.number[r][c] >= 0 && this.number[r][c] <= 5;
    }

    public boolean isNumber(Address pos) {
        return this.isNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    int[][][] getState() {
        return this.state;
    }

    int[][] getNumber() {
        return this.number;
    }

    public int getState(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.state[d][r][c];
        }
        return -9;
    }

    public int getState(SideAddress pos) {
        return this.getState(pos.d(), pos.r(), pos.c());
    }

    public void setState(int d, int r, int c, int st) {
        this.state[d][r][c] = st;
    }

    public void setState(SideAddress pos, int st) {
        this.setState(pos.d(), pos.r(), pos.c(), st);
    }

    public boolean isLine(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.state[d][r][c] == 1;
        }
        return false;
    }

    public Link getLink(SideAddress pos) {
        if (this.isSideOn(pos)) {
            return this.link[pos.d()][pos.r()][pos.c()];
        }
        return null;
    }

    public Link getLink(Address p) {
        int d = 0;
        while (d < 4) {
            Link link = this.getLink(SideAddress.get(p, d));
            if (link != null) {
                return link;
            }
            ++d;
        }
        return null;
    }

    public void setLink(SideAddress pos, Link l) {
        this.link[pos.d()][pos.r()][pos.c()] = l;
    }

    public void changeState(SideAddress p, int st) {
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new BorderEditStep(p, prev, st));
        }
        this.setState(p, st);
        if (prev == 1) {
            this.cutLink(p);
        }
        if (st == 1) {
            this.connectLink(p);
        }
    }

    public void changeNumber(Address p, int n) {
        int prev = this.getNumber(p);
        if (prev == n) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, prev, n));
        }
        this.setNumber(p, n);
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeState(s.getPos(), s.getBefore());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeState(s.getPos(), s.getAfter());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getAfter());
        }
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt3(this.state, 0);
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        SideAddress[] sideAddressArray = this.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            if (this.getState(p) == -1) {
                this.changeState(p, 0);
            }
            ++n2;
        }
    }

    @Override
    public void initBoard() {
        this.initLinks();
    }

    void initLinks() {
        Link.resetId();
        this.linkList.clear();
        ArrayUtil.initArrayObject2(this.link[0], null);
        ArrayUtil.initArrayObject2(this.link[1], null);
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.initLink(p);
            ++n2;
        }
    }

    void initLink(Address p) {
        this.initializingLink = new Link();
        int d = 0;
        while (d < 4) {
            this.initLink1(SideAddress.get(p, d));
            ++d;
        }
        if (!this.initializingLink.isEmpty()) {
            this.linkList.add(this.initializingLink);
        }
    }

    private void initLink1(SideAddress p) {
        if (!this.isSideOn(p)) {
            return;
        }
        if (this.getState(p) != 1) {
            return;
        }
        if (this.getLink(p) != null) {
            return;
        }
        this.initializingLink.add(p);
        this.setLink(p, this.initializingLink);
        int d = 0;
        while (d < 6) {
            this.initLink1(SideAddress.nextBorder(p, d));
            ++d;
        }
    }

    void connectLink(SideAddress p) {
        Link link;
        Link newLink = new Link();
        int d = 0;
        while (d < 2) {
            link = this.getLink(SideAddress.nextCellFromBorder(p, d));
            if (link != null && link.size() > newLink.size()) {
                newLink = link;
            }
            ++d;
        }
        if (newLink.isEmpty()) {
            this.linkList.add(newLink);
        }
        d = 0;
        while (d < 2) {
            link = this.getLink(SideAddress.nextCellFromBorder(p, d));
            if (link != null && link != newLink) {
                for (SideAddress b : link) {
                    this.setLink(b, newLink);
                    newLink.add(b);
                }
                this.linkList.remove(link);
            }
            ++d;
        }
        newLink.add(p);
        this.setLink(p, newLink);
    }

    void cutLink(SideAddress p) {
        Link oldLink = this.getLink(p);
        Link longerLink = new Link();
        for (SideAddress b : oldLink) {
            this.setLink(b, null);
        }
        this.linkList.remove(oldLink);
        int d = 0;
        while (d < 2) {
            Address p1 = SideAddress.nextCellFromBorder(p, d);
            this.initLink(p1);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
            ++d;
        }
        longerLink.setId(oldLink.getId());
    }

    public int countLine(Address p) {
        int no = 0;
        int d = 0;
        while (d < 4) {
            SideAddress b = SideAddress.get(p, d);
            if (this.isSideOn(b) && this.getState(b) == 1) {
                ++no;
            }
            ++d;
        }
        return no;
    }

    public int lineAround(int r, int c) {
        int nl = 0;
        if (this.getState(SideAddress.sideAddress(0, r, c)) == 1) {
            ++nl;
        }
        if (this.getState(SideAddress.sideAddress(1, r, c)) == 1) {
            ++nl;
        }
        if (this.getState(SideAddress.sideAddress(0, r + 1, c)) == 1) {
            ++nl;
        }
        if (this.getState(SideAddress.sideAddress(1, r, c + 1)) == 1) {
            ++nl;
        }
        return nl;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        int nline = 0;
        int number = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int l = this.countLine(p);
            if (l > 2) {
                result |= 1;
            } else if (l == 1) {
                result |= 2;
            }
            ++n2;
        }
        int r = 0;
        while (r < this.rows() - 1) {
            int c = 0;
            while (c < this.cols() - 1) {
                number = this.getNumber(r, c);
                if (number >= 0 && number <= 4) {
                    nline = this.lineAround(r, c);
                    if (nline > number) {
                        result |= 4;
                    } else if (nline < number) {
                        result |= 0x20;
                    }
                }
                ++c;
            }
            ++r;
        }
        if (this.linkList.size() > 1) {
            result |= 0x10;
        } else if (this.linkList.size() == 0) {
            result |= 0x80;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("slitherlink.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("slitherlink.AnswerCheckMessage2"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("slitherlink.AnswerCheckMessage5"));
        }
        if ((result & 0x80) == 128) {
            message.append(Messages.getString("slitherlink.AnswerCheckMessage8"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("slitherlink.AnswerCheckMessage3"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("slitherlink.AnswerCheckMessage6"));
        }
        return message.toString();
    }
}

