/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.util.Colors;
import pencilbox.yajilin.Board;

public class Panel
extends PanelEventHandler {
    private Board board;
    private boolean warnBranchedLink = false;
    private boolean colorForEachLink = false;
    private Color whiteColor = Color.MAGENTA;
    private Color lineColor = Color.BLUE;
    private Color blackColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;
    private Color errorColor = Color.RED;
    private Address pos0 = new Address();

    public boolean isColorForEachLink() {
        return this.colorForEachLink;
    }

    public void setColorForEachLink(boolean colorForEachLink) {
        this.colorForEachLink = colorForEachLink;
    }

    public boolean isWarnBranchedLink() {
        return this.warnBranchedLink;
    }

    public void setWarnBranchedLink(boolean warnBranchedLink) {
        this.warnBranchedLink = warnBranchedLink;
    }

    public Color getBlackColor() {
        return this.blackColor;
    }

    public void setBlackColor(Color blackColor) {
        this.blackColor = blackColor;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getWhiteColor() {
        return this.whiteColor;
    }

    public void setWhiteColor(Color whiteColor) {
        this.whiteColor = whiteColor;
    }

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMaxInputNumber(9);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null && this.isProblemEditMode()) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        int state;
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                state = this.board.getNumber(r, c);
                if (state == -2) {
                    g.setColor(this.blackColor);
                    if (this.warnBranchedLink && this.board.isBlock(r, c)) {
                        g.setColor(this.errorColor);
                    }
                    this.paintCell(g, r, c);
                } else if (state == -1) {
                    g.setColor(this.whiteColor);
                    this.placeCircle(g, r, c);
                } else if (state >= 0) {
                    g.setColor(this.getNumberColor());
                    this.placeArrow(g, r, c, state);
                } else if (state == -4) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        int d = 0;
        while (d <= 1) {
            int r2 = 0;
            while (r2 < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    state = this.board.getState(d, r2, c);
                    if (state == 1) {
                        g.setColor(this.lineColor);
                        if (this.colorForEachLink) {
                            g.setColor(Colors.getColor(this.board.getLink(d, r2, c).getID()));
                        }
                        if (this.warnBranchedLink && this.board.isBranchedLink(d, r2, c)) {
                            g.setColor(this.errorColor);
                        }
                        this.placeTraversalLine(g, d, r2, c);
                    } else if (state == -1) {
                        g.setColor(this.crossColor);
                        this.placeSideCross(g, d, r2, c);
                    }
                    ++c;
                }
                ++r2;
            }
            ++d;
        }
    }

    private void placeArrow(Graphics g, int r, int c, int arrow) {
        this.placeSquare(g, r, c, r, c);
        g.setColor(Color.BLACK);
        int direction = arrow >> 4 & 3;
        int number = arrow & 0xF;
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        direction = this.rotateDirection(direction);
        this.drawArrow(g, this.pos0.r, this.pos0.c, number, direction);
    }

    private void drawArrow(Graphics g, int r, int c, int number, int direction) {
        char arrowChar = '\u0000';
        if (direction == 0) {
            arrowChar = '\u2191';
        } else if (direction == 2) {
            arrowChar = '\u2193';
        } else if (direction == 1) {
            arrowChar = '\u2190';
        } else if (direction == 3) {
            arrowChar = '\u2192';
        }
        String arrowS = Character.toString(arrowChar);
        String numberS = Integer.toString(number);
        FontMetrics metrics = g.getFontMetrics();
        if ((direction & 1) == 0) {
            g.drawString(arrowS, this.toX(c) + (this.getCellSize() - 1 - metrics.charWidth(arrowChar)) / 2 + 1 + this.getHalfCellSize() * 4 / 5, this.toY(r) + (this.getCellSize() - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        } else if ((direction & 1) == 1) {
            g.drawString(arrowS, this.toX(c) + (this.getCellSize() - 1 - metrics.charWidth(arrowChar)) / 2 + 1, this.toY(r) + (this.getCellSize() - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1 - this.getHalfCellSize() * 4 / 5);
        }
        g.drawString(numberS, this.toX(c) + (this.getCellSize() - 1 - metrics.stringWidth(numberS)) / 2 + 1, this.toY(r) + (this.getCellSize() - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r == dragEnd.r || dragStart.c == dragEnd.c) {
            this.board.determineInlineState(dragStart, dragEnd, 1);
        }
    }

    protected void rightDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r == dragEnd.r || dragStart.c == dragEnd.c) {
            this.board.determineInlineState(dragStart, dragEnd, -3);
        }
    }

    protected void leftClicked(Address pos) {
        this.board.toggleState(pos.r, pos.c, -2);
    }

    protected void rightClicked(Address position) {
        this.board.toggleState(position.r, position.c, -1);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            this.board.enterNumber(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.eraseNumber(pos.r, pos.c);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.enterNumber(pos.r, pos.c, -4);
        }
    }
}

