/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Square;

public class Panel
extends PanelEventHandler {
    private int maxNumber = 9;
    private Board board;
    private boolean warnWrongWall = false;
    private boolean showContinuousRoom = false;
    private Color paintColor = Color.BLUE;
    private Color circleColor = Color.MAGENTA;
    private Color noRoomColor = new Color(0xCCCCCC);
    private Color roomBorderColor = Color.BLACK;
    private Color continuousRoomColor = new Color(0x800000);
    private Color errorColor = Color.RED;
    private Color showContinuousWhiteColor = Color.RED;
    private Square draggingSquare;
    private Address dragStart = new Address(-1, -1);
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(this.maxNumber);
    }

    public void setShowContinuousRoom(boolean showContinuousRoom) {
        this.showContinuousRoom = showContinuousRoom;
    }

    public void setWarnWrongWall(boolean warnWrongWall) {
        this.warnWrongWall = warnWrongWall;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.isProblemEditMode()) {
            this.drawDragging(g);
        }
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        int st;
        int c;
        int r;
        g.setFont(this.getNumberFont());
        if (this.showContinuousRoom) {
            r = 0;
            while (r < this.board.rows()) {
                c = 0;
                while (c < this.board.cols()) {
                    g.setColor(this.continuousRoomColor);
                    if (this.board.contWH[r][c] >= 3) {
                        g.setColor(this.showContinuousWhiteColor);
                    }
                    if (this.board.contH[r][c] >= 3) {
                        this.placeMidline(g, r, c, 1);
                    }
                    g.setColor(this.continuousRoomColor);
                    if (this.board.contWV[r][c] >= 3) {
                        g.setColor(this.showContinuousWhiteColor);
                    }
                    if (this.board.contV[r][c] >= 3) {
                        this.placeMidline(g, r, c, 0);
                    }
                    ++c;
                }
                ++r;
            }
        }
        r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                st = this.board.getState(r, c);
                if (this.board.getSquare(r, c) == null) {
                    g.setColor(this.noRoomColor);
                    this.paintCell(g, r, c);
                }
                if (st == 1) {
                    g.setColor(this.paintColor);
                    if (this.warnWrongWall && (this.board.isBlock(r, c) || this.board.chain[r][c] == -1)) {
                        g.setColor(this.errorColor);
                    }
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                st = this.board.getState(r, c);
                if (st == 2) {
                    g.setColor(this.circleColor);
                    this.placeCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        Iterator itr = this.board.getSquareListIterator();
        while (itr.hasNext()) {
            g.setColor(this.roomBorderColor);
            Square square = (Square)itr.next();
            this.placeSquare(g, square.r0, square.c0, square.r1, square.c1);
            g.setColor(this.getNumberColor());
            if (square.getNumber() < 0) continue;
            if (this.warnWrongWall && square.getNumber() < square.getNBlack()) {
                g.setColor(Color.WHITE);
                this.placeFilledCircle(g, square.r0, square.c0);
                g.setColor(this.errorColor);
            }
            this.placeNumber(g, square.r0, square.c0, square.getNumber());
        }
    }

    void drawDragging(Graphics g) {
        Square square = this.draggingSquare;
        if (square == null) {
            return;
        }
        g.setColor(this.roomBorderColor);
        this.placeSquare(g, square.r0, square.c0, square.r1, square.c1);
    }

    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Address dragEnd = pos;
            this.dragStart.set(dragEnd);
            this.draggingSquare = new Square(this.dragStart.r, this.dragStart.c, dragEnd.r, dragEnd.c);
        } else {
            this.board.toggleState(pos.r, pos.c, 1);
        }
    }

    protected void rightPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Address dragEnd = pos;
            this.board.removeSquareIncluding(dragEnd.r, dragEnd.c);
        } else {
            this.board.toggleState(pos.r, pos.c, 2);
            this.currentState = this.board.getState(pos.r, pos.c);
        }
    }

    protected void leftDragged(Address pos) {
        if (this.isProblemEditMode()) {
            if (this.draggingSquare == null) {
                return;
            }
            this.draggingSquare.set(this.dragStart.r, this.dragStart.c, pos.r, pos.c);
        }
    }

    protected void leftDragFixed(Address pos) {
        if (this.isProblemEditMode()) {
            Address dragEnd = pos;
            if (this.draggingSquare == null) {
                return;
            }
            this.draggingSquare = null;
            this.board.addSquareSpanning(this.dragStart.r, this.dragStart.c, dragEnd.r, dragEnd.c);
            this.dragStart.setNowhere();
        }
    }

    protected void rightDragged(Address pos) {
        if (this.isProblemEditMode()) {
            Address dragEnd = pos;
            this.board.removeSquareIncluding(dragEnd.r, dragEnd.c);
        } else {
            int st = this.board.getState(pos.r, pos.c);
            if (st == this.currentState) {
                return;
            }
            this.board.changeStateA(pos.r, pos.c, this.currentState);
        }
    }

    protected void dragFailed() {
        this.draggingSquare = null;
        this.dragStart.setNowhere();
    }

    protected void numberEntered(Address pos, int num) {
        if (!this.isProblemEditMode()) {
            return;
        }
        Square square = this.board.getSquare(pos.r, pos.c);
        if (square != null) {
            square.setNumber(num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (!this.isProblemEditMode()) {
            return;
        }
        Square square = this.board.getSquare(pos.r, pos.c);
        if (square != null) {
            square.setNumber(-1);
        }
    }
}

