/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.PanelBase;

public class PanelEventHandler
extends PanelBase {
    private KeyHandler keyHandler = new KeyHandler();
    protected MouseHandlerCursor mouseHandlerCursor = new MouseHandlerCursor();
    private MouseHandler mouseHandler = new MouseHandler();
    private MouseHandlerEdge mouseHandlerEdge = new MouseHandlerEdge();
    private int maxInputNumber = 99;
    private int previousInput = 0;

    public PanelEventHandler() {
        this.addKeyListener(this.keyHandler);
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.addMouseListener(this.mouseHandlerEdge);
        this.addMouseListener(this.mouseHandlerCursor);
        this.setCellCursor(this.createCursor());
    }

    protected void removeMouseHandlerCursor() {
        this.removeMouseListener(this.mouseHandlerCursor);
    }

    public CellCursor createCursor() {
        return new CellCursor(this);
    }

    public void setup(BoardBase board) {
        super.setup(board);
        this.getCellCursor().setPosition(0, 0);
    }

    protected void setRotation(int rotation) {
        if (this.getCellCursor() != null) {
            Address temp = this.getCellCursor().getPosition();
            this.p2b(temp);
            super.setRotation(rotation);
            this.b2p(temp);
            this.getCellCursor().setPosition(temp);
        } else {
            super.setRotation(rotation);
        }
    }

    protected void setMaxInputNumber(int number) {
        this.maxInputNumber = number;
    }

    public void resetPreviousInput() {
        this.previousInput = 0;
    }

    public final int toC(int x) {
        return (x + this.getCellSize() - this.getOffsetx()) / this.getCellSize() - 1;
    }

    public final int toR(int y) {
        return (y + this.getCellSize() - this.getOffsety()) / this.getCellSize() - 1;
    }

    protected void numberEntered(Address pos, int num) {
    }

    protected void spaceEntered(Address pos) {
    }

    protected void minusEntered(Address pos) {
    }

    protected void slashEntered() {
        this.setProblemEditMode(!this.isProblemEditMode());
    }

    protected void leftPressed(Address position) {
    }

    protected void leftPressedShift(Address position) {
    }

    protected void leftClicked(Address position) {
    }

    protected void leftClickedShift(Address position) {
    }

    protected void leftDragged(Address position) {
    }

    protected void leftDragged(Address oldPos, Address position) {
        this.leftDragged(position);
    }

    protected void leftDragFixed(Address dragEnd) {
    }

    protected void rightPressed(Address position) {
    }

    protected void rightClicked(Address position) {
    }

    protected void rightDragged(Address position) {
    }

    protected void rightDragged(Address oldPos, Address position) {
        this.rightDragged(position);
    }

    protected void rightDragFixed(Address dragEnd) {
    }

    protected void dragFailed() {
    }

    protected void mouseMovedTo(Address pos) {
    }

    protected void leftClickedEdge(SideAddress position) {
    }

    protected void leftClickedShiftEdge(SideAddress position) {
    }

    protected void rightClickedEdge(SideAddress position) {
    }

    public class KeyHandler
    implements KeyListener {
        private Address position = new Address();

        public void keyPressed(KeyEvent e) {
            char keyChar = e.getKeyChar();
            if (keyChar == '/') {
                PanelEventHandler.this.slashEntered();
            }
            if (PanelEventHandler.this.getCellCursor() != null && (PanelEventHandler.this.isProblemEditMode() || PanelEventHandler.this.isCursorOn())) {
                this.moveCursor(e);
            }
            if (PanelEventHandler.this.isProblemEditMode() || PanelEventHandler.this.isCursorOn()) {
                this.position.set(PanelEventHandler.this.getCellCursor().getPosition());
                PanelEventHandler.this.p2b(this.position);
                if (keyChar == ' ') {
                    PanelEventHandler.this.spaceEntered(this.position);
                } else if (keyChar == '.') {
                    PanelEventHandler.this.spaceEntered(this.position);
                } else if (keyChar == '-') {
                    PanelEventHandler.this.minusEntered(this.position);
                } else if (keyChar >= '0' && keyChar <= '9') {
                    int number = keyChar - 48;
                    if (PanelEventHandler.this.previousInput >= 1 && PanelEventHandler.this.previousInput <= 9) {
                        if (PanelEventHandler.this.previousInput * 10 + number <= PanelEventHandler.this.maxInputNumber) {
                            number = PanelEventHandler.this.previousInput * 10 + number;
                        }
                        if (number <= PanelEventHandler.this.maxInputNumber) {
                            PanelEventHandler.this.numberEntered(this.position, number);
                            PanelEventHandler.this.previousInput = 0;
                        }
                    } else if (number <= PanelEventHandler.this.maxInputNumber) {
                        PanelEventHandler.this.numberEntered(this.position, number);
                        PanelEventHandler.this.previousInput = number;
                    }
                }
            }
            PanelEventHandler.this.repaint();
        }

        private void moveCursor(KeyEvent e) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 37: {
                    PanelEventHandler.this.getCellCursor().moveLt();
                    break;
                }
                case 38: {
                    PanelEventHandler.this.getCellCursor().moveUp();
                    break;
                }
                case 39: {
                    PanelEventHandler.this.getCellCursor().moveRt();
                    break;
                }
                case 40: {
                    PanelEventHandler.this.getCellCursor().moveDn();
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private Address oldPos = new Address(-1, -1);
        private Address newPos = new Address(-1, -1);

        public void mousePressed(MouseEvent e) {
            this.newPos.set(PanelEventHandler.this.toR(e.getY()), PanelEventHandler.this.toC(e.getX()));
            if (!PanelEventHandler.this.isOn(this.newPos)) {
                return;
            }
            PanelEventHandler.this.p2b(this.newPos);
            int modifier = e.getModifiers();
            if ((modifier & 0x10) != 0) {
                if ((e.getModifiersEx() & 0x40) != 0) {
                    PanelEventHandler.this.leftPressedShift(this.newPos);
                } else {
                    PanelEventHandler.this.leftPressed(this.newPos);
                }
            } else if ((modifier & 4) != 0) {
                PanelEventHandler.this.rightPressed(this.newPos);
            }
            this.oldPos.set(this.newPos);
            PanelEventHandler.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            this.newPos.set(PanelEventHandler.this.toR(e.getY()), PanelEventHandler.this.toC(e.getX()));
            if (!PanelEventHandler.this.isOn(this.newPos)) {
                this.oldPos.setNowhere();
                return;
            }
            PanelEventHandler.this.p2b(this.newPos);
            if (this.newPos.equals(this.oldPos)) {
                return;
            }
            if ((e.getModifiers() & 0x10) != 0) {
                PanelEventHandler.this.leftDragged(this.oldPos, this.newPos);
            } else if ((e.getModifiers() & 4) != 0) {
                PanelEventHandler.this.rightDragged(this.oldPos, this.newPos);
            }
            this.oldPos.set(this.newPos);
            PanelEventHandler.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (!PanelEventHandler.this.isOn(this.oldPos)) {
                PanelEventHandler.this.dragFailed();
                PanelEventHandler.this.repaint();
                return;
            }
            if ((e.getModifiers() & 0x10) != 0) {
                PanelEventHandler.this.leftDragFixed(this.oldPos);
            } else if ((e.getModifiers() & 4) != 0) {
                PanelEventHandler.this.rightDragFixed(this.oldPos);
            }
            PanelEventHandler.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (!PanelEventHandler.this.isOn(this.newPos)) {
                return;
            }
            int modifier = e.getModifiers();
            if ((modifier & 0x10) != 0) {
                if ((e.getModifiersEx() & 0x40) != 0) {
                    PanelEventHandler.this.leftClickedShift(this.newPos);
                } else {
                    PanelEventHandler.this.leftClicked(this.newPos);
                }
            } else if ((modifier & 4) != 0) {
                PanelEventHandler.this.rightClicked(this.newPos);
            }
            PanelEventHandler.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    public class MouseHandlerEdge
    implements MouseListener {
        private SideAddress position = new SideAddress();

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (((y - PanelEventHandler.this.getOffsety() - (x - PanelEventHandler.this.getOffsetx()) + PanelEventHandler.this.cols() * PanelEventHandler.this.getCellSize() * 2) / PanelEventHandler.this.getCellSize() + (y - PanelEventHandler.this.getOffsety() + (x - PanelEventHandler.this.getOffsetx())) / PanelEventHandler.this.getCellSize()) % 2 == 0) {
                this.position.set(0, PanelEventHandler.this.toR(y), PanelEventHandler.this.toC(x - PanelEventHandler.this.getHalfCellSize()));
            } else {
                this.position.set(1, PanelEventHandler.this.toR(y - PanelEventHandler.this.getHalfCellSize()), PanelEventHandler.this.toC(x));
            }
            if (!PanelEventHandler.this.isSideOn(this.position)) {
                return;
            }
            PanelEventHandler.this.p2bSide(this.position);
            int modifier = e.getModifiers();
            if ((modifier & 0x10) != 0) {
                if ((e.getModifiersEx() & 0x40) != 0) {
                    PanelEventHandler.this.leftClickedShiftEdge(this.position);
                } else {
                    PanelEventHandler.this.leftClickedEdge(this.position);
                }
            } else if ((modifier & 4) != 0) {
                PanelEventHandler.this.rightClickedEdge(this.position);
            }
            PanelEventHandler.this.repaint();
        }
    }

    public class MouseHandlerCursor
    implements MouseListener {
        public void mousePressed(MouseEvent e) {
            PanelEventHandler.this.getCellCursor().setPosition(PanelEventHandler.this.toR(e.getY()), PanelEventHandler.this.toC(e.getX()));
            PanelEventHandler.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

