/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * (c) Copyright 1999-2003 by Tsukuba Bunko.
 *
 * $Id: ReflectionUtilTest.java,v 1.2 2003/08/31 14:08:52 ppoi Exp $
 */
package tsukuba_bunko.util.test;

import	java.lang.reflect.Method;

import	java.util.Arrays;

import	junit.framework.TestCase;

import	tsukuba_bunko.util.ReflectionUtil;


/**
 * @author	$Author: ppoi $
 * @version	$Revision: 1.2 $
 */
public class ReflectionUtilTest extends TestCase {

	/**
	 */
	public ReflectionUtilTest( String name )
	{
		super( name );
	}



	public void test_findMethod_I[o[ChꍇeNXǂꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{ String.class, boolean.class };

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodA", parameterTypes, true );
		assertNotNull( "os", method );
		assertEquals( "錾Ă^Ⴄ", ReflectionTestClassB.class, method.getDeclaringClass() );
		assertTrue( "^CvႤ", Arrays.equals(method.getParameterTypes(), parameterTypes) );
	}

	public void test_findMethod_I[o[Chꍇ̃NX̏ꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{ String.class, boolean.class };

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodA", parameterTypes, false );
		assertNotNull( "os", method );
		assertEquals( "錾Ă^Ⴄ", ReflectionTestClassB.class, method.getDeclaringClass() );
		assertTrue( "^CvႤ", Arrays.equals(method.getParameterTypes(), parameterTypes) );
	}

	public void test_findMethod_I[o[ChĂȂꍇeNXǂꍇX[p[NX()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{ String.class, boolean.class };

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodB", parameterTypes, true );
		assertNotNull( "os", method );
		assertEquals( "錾Ă^Ⴄ", ReflectionTestClassA.class, method.getDeclaringClass() );
		assertTrue( "^CvႤ", Arrays.equals(method.getParameterTypes(), parameterTypes) );
	}

	public void test_findMethod_I[o[ChĂȂꍇ̃NX̏ꍇX[p[NX()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{ String.class, boolean.class };

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodB", parameterTypes, false );
		assertNull( "ςȂ̂oĂ", method );
	}

	public void test_findMethod_I[o[ChĂȂꍇeNXǂꍇTuNX()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{ String.class };

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodB", parameterTypes, true );
		assertNotNull( "os", method );
		assertEquals( "錾Ă^Ⴄ", ReflectionTestClassB.class, method.getDeclaringClass() );
		assertTrue( "^CvႤ", Arrays.equals(method.getParameterTypes(), parameterTypes) );
	}

	public void test_findMethod_I[o[ChĂȂꍇ̃NX̏ꍇTuNX()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{ String.class };

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodB", parameterTypes, false );
		assertNotNull( "os", method );
		assertEquals( "錾Ă^Ⴄ", ReflectionTestClassB.class, method.getDeclaringClass() );
		assertTrue( "^CvႤ", Arrays.equals(method.getParameterTypes(), parameterTypes) );
	}

	public void test_findMethod_TuNXƎ\bheNXǂꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{};

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodC", parameterTypes, true );
		assertNotNull( "os", method );
		assertEquals( "錾Ă^Ⴄ", ReflectionTestClassB.class, method.getDeclaringClass() );
		assertTrue( "^CvႤ", Arrays.equals(method.getParameterTypes(), parameterTypes) );
	}

	public void test_findMethod_TuNXƎ\bh̃NX̏ꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{};

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodC", parameterTypes, false );
		assertNotNull( "os", method );
		assertEquals( "錾Ă^Ⴄ", ReflectionTestClassB.class, method.getDeclaringClass() );
		assertTrue( "^CvႤ", Arrays.equals(method.getParameterTypes(), parameterTypes) );
	}

	public void test_findMethod_݂Ȃ\bheNXǂꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{};

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodD", parameterTypes, true );
		assertNull( "ςȃNXoꂽ", method );
	}

	public void test_findMethod_݂Ȃ\bh̃NX̏ꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{};

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodD", parameterTypes, false );
		assertNull( "ςȃNXoꂽ", method );
	}

	public void test_findMethod_X[p[NXƎ\bheNXǂꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{};

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodE", parameterTypes, true );
		assertNotNull( "os", method );
		assertEquals( "錾Ă^Ⴄ", ReflectionTestClassA.class, method.getDeclaringClass() );
		assertTrue( "^CvႤ", Arrays.equals(method.getParameterTypes(), parameterTypes) );
	}

	public void test_findMethod_X[p[NXƎ\bh̃NX̏ꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{};

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodE", parameterTypes, false );
		assertNull( "ςȃNXoꂽ", method );
	}

	public void test_findMethod_݂ȂI[o[[heNXǂꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{};

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodA", parameterTypes, true );
		assertNull( "ςȃNXoꂽ", method );
	}

	public void test_findMethod_݂ȂI[o[[h̃NX̏ꍇ()
		throws Exception
	{
		Class[]	parameterTypes = new Class[]{};

		Method	method = ReflectionUtil.findMethod( ReflectionTestClassB.class, "testMethodA", parameterTypes, false );
		assertNull( "ςȃNXoꂽ", method );
	}
}