package tsukuba_bunko.resource.test;

import	java.net.URL;

import	tsukuba_bunko.resource.IllegalResourceException;
import	tsukuba_bunko.resource.Resources;

import	junit.framework.TestCase;


/**
 * <code>IntegerDeserializer</code> eXg TestCase ł.
 * @author	$Author: ppoi $
 * @see	tsukuba_bunko.resource.IntegerDeserializer
 */
public class NumberDeserializerTestCase	extends TestCase	{

	/**
	 * <code>NumberDeserializerTestCase</code> ̃CX^X쐬܂.
	 */
	public NumberDeserializerTestCase( String name )
	{
		super( name );
	}


	public void testLoad()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-integer.xml" );
		assertNotNull( "resource file not found", resourceURL );

		System.setProperty( "libtbas.resource.mapping", "tsukuba_bunko.resource.test.test_mapping" );
		Resources	resources = Resources.newInstance( resourceURL );

		Integer	value = (Integer)resources.getResource( "tbas.libtbas.resource-manager.test.item1" );
		assertNotNull( "item1", value );
		assertEquals( "item1", value, new Integer(1) );

		value = (Integer)resources.getResource( "tbas.libtbas.resource-manager.test.item2" );
		assertNotNull( "item2", value );
		assertEquals( "item2", value, new Integer(2) );

		value = (Integer)resources.getResource( "tbas.libtbas.resource-manager.hoge" );
		assertNotNull( "hoge", value );
		assertEquals( "hoge", value, new Integer(3) );
	}

	public void testLoadIllegal1()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-integer-illegal1.xml" );
		assertNotNull( "resource file not found", resourceURL );

		try	{
			System.setProperty( "libtbas.resource.mapping", "tsukuba_bunko.resource.test.test_mapping" );
			Resources.newInstance( resourceURL );
			assertTrue( "exception", false );
		}
		catch( IllegalResourceException ire )	{
			ire.printStackTrace();
		}
	}

	public void testLoadIllegal2()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-integer-illegal2.xml" );
		assertNotNull( "resource file not found", resourceURL );

		try	{
			System.setProperty( "libtbas.resource.mapping", "tsukuba_bunko.resource.test.test_mapping" );
			Resources.newInstance( resourceURL );
			assertTrue( "exception", false );
		}
		catch( IllegalResourceException ire )	{
			ire.printStackTrace();
		}
	}
}
