/*
 * Common Library for TBAS Softwares
 *
 * All Rights Reserved.
 * (c) Copyright 2002 by Tsukuba Bunko.
 *
 * $Id: MessageFormatDeserializerTestCase.java,v 1.1 2003/08/31 08:20:49 ppoi Exp $
 */
package tsukuba_bunko.resource.test;

import	java.net.URL;
import	java.text.MessageFormat;

import junit.framework.TestCase;

import	tsukuba_bunko.resource.Resources;


/**
 * {@link tsukuba_bunko.resource.MessageFormatDeserializer} eXg TestCase łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1 $
 */
public class MessageFormatDeserializerTestCase	extends TestCase	{

	/**
	 * <code>MessageFormatDeserializerTestCase</code> ̃CX^X𐶐܂B
	 */
	public MessageFormatDeserializerTestCase( String name )
	{
		super( name );
	}


	public void testLoad()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-messageformat.xml" );
		assertNotNull( "resource file not found", resourceURL );

//		System.setProperty( "libtbas.resource.mapping", "tsukuba_bunko.resource.test.test_mapping" );
		Resources	resources = Resources.newInstance( resourceURL );

		MessageFormat	value = (MessageFormat)resources.getResource( "tbas.libtbas.resource-manager.test.item1" );
		assertNotNull( "item1", value );
		Object[]	params = { "1", "2" };
		String	pattern = "testmessage {0} {1}";
		assertEquals( "item1-pattern", pattern, value.toPattern() );
		assertEquals( "item1-message", "testmessage 1 2", value.format(params) );
		assertEquals( "item1-format", MessageFormat.format(pattern, params), value.format(params) );

		Integer	intValue = (Integer)resources.getResource( "tbas.libtbas.resource-manager.hoge" );
		assertNotNull( "hoge", intValue );
		assertEquals( "hoge", intValue, new Integer(3) );
	}
}
