/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: SceneFlowHandler.java,v 1.1.2.1 2003/12/11 10:17:57 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.util;

import	org.xml.sax.Attributes;

import	tsukuba_bunko.peko.scenario.ElementHandler;
import	tsukuba_bunko.peko.scenario.PSMLUtil;
import	tsukuba_bunko.peko.scenario.NextSceneMapping;


/**
 * @author	${Author}$
 * @version	${Revision}$
 */
public class SceneFlowHandler	extends ElementHandler	{


	public void endDocument()
	{
		setEndOfScene( true );
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
	{
		String	nextSceneName = PSMLUtil.getAttributeValue( attrs, "next-scene" );
		if( nextSceneName != null )	{
			nextSceneName = nextSceneName.trim();
			if( nextSceneName.length() > 0 )	{
				NextSceneMapping	mapping = new NextSceneMapping();
				mapping.setDefaultSceneMapping( nextSceneName );
				getSceneContext().setNextSceneMapping( mapping );
			}
		}
	}
}