/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: TextCoordinator.java,v 1.1.2.1 2003/12/11 10:17:57 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.text;

import	java.awt.Dimension;

import	java.awt.font.LineBreakMeasurer;
import	java.awt.font.TextAttribute;
import	java.awt.font.TextLayout;

import	java.text.AttributedString;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.canvas.text.Line;
import	tsukuba_bunko.peko.canvas.text.Page;

import	tsukuba_bunko.peko.resource.ResourceManager;

import	tsukuba_bunko.peko.scenario.Coordinator;
import	tsukuba_bunko.peko.scenario.SceneContext;


/**
 * TextCanvas ւ̑莝R[fBl[^W[łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class TextCoordinator	extends Coordinator	{

	/**
	 * Page ̐ݒsǂ
	 */
	protected boolean	_pageConfigured = false;

	/**
	 * sԊu
	 */
	protected float	_lineSpan = 0f;

	/**
	 * ŏIs
	 */
	protected Line	_lastLine = null;


	/**
	 * Dimension cache
	 */
	protected Dimension	_sizeCache = new Dimension();


	/**
	 * <code>TextCoordinator</code> ̃CX^X𐶐܂B
	 */
	public TextCoordinator()
	{
		super();
	}


	public void prepare( SceneContext context, Thread activeThread )
	{
		super.prepare( context, activeThread );
		_pageConfigured = false;
		_lastLine = null;
	}


	/**
	 * TextCanvas ւ̑Jn܂B
	 */
	public void begin()
	{
		if( isActiveThread() )	{
			_lastLine = null;
			getActionControler().setSaveEnabled( true );
		}
	}

	/**
	 * TextCanvas ւ̑IALoX̏Ԃm肵܂B
	 */
	public void commit()
	{
		if( isActiveThread() )	{
			getActionControler().setSaveEnabled( false );
			getCurrentPage().commit();
		}
	}

	/**
	 * \镶͂ TextCanvsa ɑM܂B
	 * @param	text	\镶
	 */
	public void pushText( String text )
	{
		if( !isActiveThread() )	{
			return;
		}

		Page	page = getCurrentPage();
		if( !_pageConfigured )	{
			PageConfigurator.configure( page, getSceneContext() );
			_pageConfigured = true;
			_lineSpan = getLineSpan();
		}

		int	length = text.length();
		if( length == 0 )	{
			Logger.debug( "[scnario.text] empty string is pecified." );
			return;
		}

		if( _lastLine != null )	{
			text = _lastLine.getText() + text;
			length = text.length();
		}
		Logger.debug( text );

		AttributedString	astring = new AttributedString( text );
		astring.addAttribute( TextAttribute.FONT, page.getDefaultFont() );
		astring.addAttribute( TextAttribute.FOREGROUND, page.getForeground() );

		LineBreakMeasurer	lbm = new LineBreakMeasurer( astring.getIterator(), page.getFontRenderContext() );
		float	maxWidth = page.getMaxLineWidth();
		float	lineSpan = _lineSpan;
		TextLayout	layout = null;
		Line	line = null;

		layout = lbm.nextLayout( maxWidth );
		line = new Line();
		line.setTextLayout( layout );
		line.setText( text.substring(0, lbm.getPosition()) );
		line.setForeground( page.getForeground() );
		line.setShadowColor( page.getShadow() );

		if( _lastLine == null )	{
			if( isActiveThread() )	{
				line.setLineSpan( lineSpan );	//	zg͂ margin-top ݒ肷fXB
				if( !page.isAdaptive(line) )	{
					page = advancesNewPage();
				}
				page.addLine( line );
			}
			else	{
				return;
			}
		}
		else	{
			line.setLineSpan( lineSpan );
			if( isActiveThread() )	{
				page.setLine( (page.getLineCount() - 1), line );
			}
			else	{
				return;
			}
		}
		_lastLine = line;

		int	lastLinePosition = 0;
		while( lbm.getPosition() < length )	{
			lastLinePosition = lbm.getPosition();
			line = new Line();
			line.setTextLayout( lbm.nextLayout(maxWidth) );
			line.setLineSpan( lineSpan );
			line.setText( text.substring(lastLinePosition, lbm.getPosition()) );
			line.setForeground( page.getForeground() );
			line.setShadowColor( page.getShadow() );
			if( isActiveThread() )	{
				if( !page.isAdaptive(line) )	{
					page.updateContents();
					stop();	//	[I
					page = advancesNewPage();
				}
				if( page != null )	{
					page.addLine( line );
				}
				else	{
					return;
				}
				_lastLine = line;
			}
			else	{
				return;
			}
		}
		if( isActiveThread() )	{
			page.updateContents();
		}
	}

	/**
	 * ݕ\̃y[W擾܂B
	 * @return	ݕ\̃y[W
	 */
	public Page getCurrentPage()
	{
		return getCanvasManager().getCurrentPage();
	}

	/**
	 * Vy[Wɐ؂ւAVy[W擾܂B
	 * @return	Vy[W
	 */
	public Page advancesNewPage()
	{
		if( isActiveThread() )	{
			return getCanvasManager().advancesNewPage();
		}
		else	{
			return null;
		}
	}

	/**
	 * ꎞ~܂B
	 */
	protected void stop()
	{
		if( isActiveThread() )	{
			getActionControler().stop();
		}
	}

	/**
	 * sԊu擾܂B
	 * @return	sԊu
	 */
	protected float getLineSpan()
	{
		SceneContext	context = getSceneContext();
		String	value = context.getProperty( PropertyIDs.CANVAS_TEXT_LINESPAN );
		if( value != null )	{
			try	{
				return Float.parseFloat( value );
			}
			catch( Exception e )	{
				Logger.warn( MessageIDs.SCN2002W, e );
			}
		}

		ResourceManager	resources = ResourceManager.getInstance();
		Float	lineSpan = (Float)resources.getResource( ResourceIDs.CANVAS_TEXT_LINESPAN );
		if( lineSpan != null )	{
			return lineSpan.floatValue();
		}
		else	{
			Logger.warn( MessageIDs.SCN2001W, new Object[]{"20.0"} );
			return 20f;
		}
	}
}