/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: PSMLUtilTestCase.java,v 1.1.2.1 2003/12/11 10:17:57 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.test;

import	junit.framework.TestCase;

import	tsukuba_bunko.peko.scenario.PSMLUtil;


/**
 * <code>{@see tsukuba_bunko.peko.scenario.PSMLUtil}</code> ̃eXgP[XłB
 * @author	${Author}$
 * @version	${Revision}$
 */
public class PSMLUtilTestCase extends TestCase {

	/**
	 * Constructor for PSMLUtilTestCase.
	 * @param arg0
	 */
	public PSMLUtilTestCase(String arg0)
	{
		super(arg0);
	}


	/**
	 * ISO R[h܂܂Ȃ̏ꍇB͂Əo͓͂CX^XB
	 */
	public void testRemoveISOControlChar1()
	{
		String	string = "ĂArea Text ďeXg";
		String	result = PSMLUtil.removeISOControlChar( string );
		assertEquals( "result is not equals to string.", result, string );
		assertSame( "result is not same to string.", result, string );
	}

	/**
	 * O ISO R[h܂ޕ̏ꍇB
	 */
	public void testRemoveISOControlChar2()
	{
		String	string = "ĂArea Text ďeXg";
		String	source = "\n\t\r\b" + string + "\t";
		assertTrue( !source.equals(string) );
		String	result = PSMLUtil.removeISOControlChar( source );
		assertEquals( "result is not equals to string.", result, string );
	}

	/**
	 *  ISO R[h܂ޕ̏ꍇB
	 */
	public void testRemoveISOControlChar3()
	{
		String	string = "ĂArea Text ďeXg";
		String	source = "ĂA\brea\n\t Text ď\reXg";
		assertTrue( !source.equals(string) );
		String	result = PSMLUtil.removeISOControlChar( source );
		assertEquals( "result is not equals to string.", result, string );
	}

	/**
	 * OE ISO R[h܂ޕ̏ꍇB
	 */
	public void testRemoveISOControlChar4()
	{
		String	string = "ĂArea Text ďeXg";
		String	source = "\nĂ\t\r\bA\brea\n\t Text ď\reXg\t\b\b\b\b";
		assertTrue( !source.equals(string) );
		String	result = PSMLUtil.removeISOControlChar( source );
		assertEquals( "result is not equals to string.", result, string );
	}

	/**
	 * ISO R[ĥ݂̏̕ꍇB
	 */
	public void testRemoveISOControlChar5()
	{
		String	source = "\n\t\r\b\b\n\t\r\t";
		String	result = PSMLUtil.removeISOControlChar( source );
		assertEquals( "result is not empty string", result, "" );
	}
}