/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: SlideHandler.java,v 1.1.2.1 2003/12/11 10:15:10 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.stage;

import	org.xml.sax.Attributes;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.resource.ResourceManager;

import	tsukuba_bunko.peko.scenario.PSMLUtil;


/**
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class SlideHandler	extends StageElementHandler	{

	/**
	 * <code>SlideHandler</code> ̃CX^X𐶐܂B
	 */
	public SlideHandler()
	{
		super();
	}


//
//	ElementHandler ̎
//
	public void startElement( String namspaceURI, String localName, String qName, Attributes attrs )
	{
		StageCoordinator	coordinator = getStageCoordinator();
		if( "show-slide".equals(localName) )	{
			String	slide = PSMLUtil.getAttributeValue( attrs, "image" );
			if( slide == null )	{
				Logger.warn( MessageIDs.SCN3006W, new Object[]{getSceneContext().getCurrentPath()} );
				return;
			}
			else	{
				coordinator.showSlide( slide );
			}

			String	effect = PSMLUtil.getAttributeValue( attrs, "effect" );
			if( effect == null )	{
				ResourceManager	resources = ResourceManager.getInstance();
				effect = (String)resources.getResource( ResourceIDs.DEFAULT_EFFECT_SLIDE, true );
			}
			coordinator.updateStage( effect );
		}
		else if( "hide-slide".equals(localName) )	{
			coordinator.hideSlide();

			String	effect = PSMLUtil.getAttributeValue( attrs, "effect" );
			if( effect == null )	{
				ResourceManager	resources = ResourceManager.getInstance();
				effect = (String)resources.getResource( ResourceIDs.DEFAULT_EFFECT_SLIDE, true );
			}
			coordinator.updateStage( effect );
		}
	}
}
