/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: Coordinator.java,v 1.1.2.1 2003/12/11 10:13:39 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario;

import	tsukuba_bunko.peko.ActionControler;
import	tsukuba_bunko.peko.PekoSystem;

import	tsukuba_bunko.peko.canvas.CanvasManager;


/**
 * Canvas W[ɑ΂鑀莝NX̊{@\񋟂܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public abstract class Coordinator	{

	/**
	 * V[ReNXg
	 */
	protected SceneContext	_context = null;

	/**
	 * ݃ANeBuȃV[Xbh
	 */
	protected Thread	_activeThread = null;


	/**
	 * <code>Coordinator</code> ̃CX^X𐶐܂B
	 */
	protected Coordinator()
	{
		super();
	}


	/**
	 *  Coordinator CX^Xw肳ꂽReNXgAV[Xbhœ삷悤ɐݒ肵܂B
	 * @param	context	V[ReNXg
	 * @param	activeThread	ANeBuȃV[Xbh
	 */
	public void prepare( SceneContext context, Thread activeThread )
	{
		_context = context;
		_activeThread = activeThread;
	}

	/**
	 * Coordinator ANeBuɂ܂B
	 */
	public void dormantize()
	{
		_activeThread = null;
	}

	public abstract void begin();

	public abstract void commit();

	/**
	 * ݂̃XbhANeBuȃXbhǂ𔻒肵܂B
	 * @return	݂̃XbhANeBuȏꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	protected boolean isActiveThread()
	{
		return (_activeThread == Thread.currentThread());
	}

	/**
	 * ݏ̃V[ReNXg擾܂B
	 * @return	V[ReNXg
	 */
	protected SceneContext getSceneContext()
	{
		return _context;
	}

	/**
	 * CanvasManager 擾܂B
	 * @return	CanvasManager
	 */
	protected CanvasManager getCanvasManager()
	{
		return PekoSystem.getInstance().getCanvasManager();
	}

	/**
	 * ActionControler 擾܂B
	 * @return	ActionControler
	 */
	protected ActionControler getActionControler()
	{
		return PekoSystem.getInstance().getActionControler();
	}
}