/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: Line.java,v 1.1.2.1 2003/12/11 10:22:54 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.text;

import	java.io.Serializable;

import	java.awt.Color;
import	java.awt.Graphics2D;
import	java.awt.Shape;

import	java.awt.font.TextAttribute;
import	java.awt.font.TextLayout;

import	java.text.AttributedString;


/**
 * y[Wɕ`悳słB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class Line	implements Serializable	{

	/**
	 * `悷 TextLayout
	 */
	transient private TextLayout	_textLayout = null;

	/**
	 * shadow
	 */
	transient private Shape	_shape = null;

	/**
	 * line span
	 */
	private float	_lineSpan = 0f;

	/**
	 */
	private Color	_foreground = null;

	/**
	 */
	private Color	_shadowColor = Color.black;

	/**
	 * ̍sɕ`悳镶
	 */
	private String	_text = null;


	/**
	 * <code>Line</code> ̃CX^X쐬܂B
	 */
	public Line()
	{
		super();
	}

	/**
	 * `ɎgpOiFw肵܂B
	 * @param	color	OiF
	 */
	public void setForeground( Color color )
	{
		_foreground = color;
	}

	/**
	 * `ɎgpOiF擾܂B
	 * @return	OiF
	 */
	public Color getForeground()
	{
		return _foreground;
	}

	/**
	 * `Ɏgpe̐Fw肵܂B
	 * @param	color	e̐F
	 */
	public void setShadowColor( Color color )
	{
		_shadowColor = color;
	}

	/**
	 * `Ɏgpe̐F擾܂B
	 * @return	`Ɏgpe̐F
	 */
	public Color getShadowColor()
	{
		return _shadowColor;
	}

	/**
	 * `悷镶ݒ肵܂B
	 * @param	text	`悷镶
	 */
	public void setText( String text )
	{
		_text = text;
	}

	/**
	 * `悷镶擾܂B
	 * @return	`悷镶
	 */
	public String getText()
	{
		return _text;
	}

	/**
	 * `悷 TextLayout ݒ肵܂B
	 * @param	layout	`悷 TextLayout
	 */
	public void setTextLayout( TextLayout layout )
	{
		_textLayout = layout;
		_shape = layout.getOutline( null );
	}

	/**
	 * `悷 TextLayout 擾܂B
	 * @return	`悷 TextLayout
	 */
	public TextLayout getTextLayout()
	{
		return _textLayout;
	}

	/**
	 * sԊuݒ肵܂B
	 * @param	lineSpan	sԊu
	 */
	public void setLineSpan( float lineSpan )
	{
		_lineSpan = lineSpan;
	}

	/**
	 * sԊu擾܂B
	 * @return	sԊu
	 */
	public float getLineSpan()
	{
		return _lineSpan;
	}

	/**
	 * x[XC̒̕(ascent)擾܂Bascent ɂ́AsԊu܂܂܂B
	 * @return	ascent
	 */
	public float getAscent()
	{
		return _textLayout.getAscent() + _lineSpan;
	}

	/**
	 * x[XC艺̒̕(descent)擾܂B
	 * @return	descent
	 */
	public float getDescent()
	{
		return _textLayout.getDescent();
	}

	/**
	 * s̒(advance)擾܂B
	 * @return	advance
	 */
	public float getAdavance()
	{
		return _textLayout.getAdvance();
	}

	/**
	 * s`悵܂B
	 * @param	g2	OtBbNReNXg
	 * @param	x	`Jnʒu x W
	 * @param	y	x[XC y W
	 */
	public void draw( Graphics2D g2, float x, float y )
	{
		Graphics2D	g = (Graphics2D)g2.create();
		g.translate( (int)x + 2, (int)y + 2 );
		if( _shadowColor == null )	{
			g.setColor( Color.black );
		}
		else	{
			g.setColor( _shadowColor );
		}
		g.setRenderingHint( java.awt.RenderingHints.KEY_ANTIALIASING, java.awt.RenderingHints.VALUE_ANTIALIAS_ON );
		g.fill( _shape );

		Color	original = g2.getColor();
		if( _foreground != null )	{
			g2.setColor( _foreground );
		}
		_textLayout.draw( g2, x, y );

		g2.setColor( original );
	}


	/**
	 * `̏s܂B
	 */
	public void prepare( Page page )
	{
		if( _textLayout == null )	{
			AttributedString	astring = new AttributedString( _text );
			astring.addAttribute( TextAttribute.FONT, page.getDefaultFont() );
			astring.addAttribute( TextAttribute.FOREGROUND, page.getForeground() );

			setTextLayout( new TextLayout(astring.getIterator(), page.getFontRenderContext()) );
		}
	}
}
