/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: PataPataEffect.java,v 1.1.2.1 2003/12/11 10:23:10 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.stage.effect;

import	java.awt.Color;
import	java.awt.Dimension;
import	java.awt.Graphics2D;

import	java.awt.image.BufferedImage;
import	java.awt.image.ImageObserver;

import	tsukuba_bunko.peko.canvas.stage.Effect;

/**
 * "ςς" GtFNgłB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class PataPataEffect	extends Effect	{

	/**
	 * <code>PataPataEffect</code> ̃CX^X쐬܂B
	 */
	public PataPataEffect()
	{
		super();
	}


	/**
	 * GtFNg "peko:pata-pata" 擾܂B
	 */
	public String getName()
	{
		return "pata-pata";
	}

	/**
	 * "pata-pata" s܂B
	 */
	public void perform( BufferedImage screen, BufferedImage next )
	{
		ImageObserver	observer = getStageCanvas();
		Graphics2D	g2 = screen.createGraphics();
		g2.setColor( Color.black );

		Dimension	size = getCanvasSize();

		int	width = size.width;
		int	height = size.height;
		int	part = (width / 16) + ( (width % 16) != 0 ? 1 : 0 );
		int	x = 0;
		int	pos = 0;

		int	d = 0;
		for( int i = 0; i < 4; ++i )	{
			x += 4;
			for( int j = part - 1; j >= 0; --j )	{
				pos = (j * 16);
				d = x;
				if( pos + x <= width )	{
					g2.setClip( pos, 0, d, height );
					g2.fillRect( 0, 0, width, height );
				}
			}
			drawImage( screen );
			try	{
				synchronized( this )	{
					wait( 25L );
				}
			}
			catch( Exception e )	{
				e.printStackTrace();
			}
		}

		try	{
			synchronized( this )	{
				wait( 100L );
			}
		}
		catch( Exception e )	{
			e.printStackTrace();
		}

		x = 0;
		pos = 0;
		d = 0;
		for( int i = 0; i < 4; ++i )	{
			x += 4;
			for( int j = part - 1; j >= 0; --j )	{
				pos = (j * 16);
				d = x;
				if( pos + x <= 640 )	{
					g2.setClip( pos, 0, d, height );
					g2.drawImage( next, 0, 0, observer );
				}
			}
			drawImage( screen );
			try	{
				synchronized( this )	{
					wait( 25L );
				}
			}
			catch( Exception e )	{
				e.printStackTrace();
			}
		}
	}
}
