/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: Stage.java,v 1.1.2.1 2003/12/11 10:23:10 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.stage;

import	java.awt.Color;
import	java.awt.Image;

import	java.io.Serializable;

import	java.util.HashMap;
import	java.util.Iterator;
import	java.util.Map;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.resource.ColorManager;


/**
 * \LoXłB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class Stage	implements Serializable	{

	/**
	 * ̃Xe[W`悷 StageCanvas
	 */
	transient private StageCanvas	_canvas = null;

	/**
	 * yĐ AudioPlayer
	 */
	private AudioPlayer	_audioPlayer = new AudioPlayer();


	/**
	 * ol
	 */
	transient private Map	_actors = new HashMap();

	/**
	 * m肵ol
	 */
	private HashMap	_committedActors = new HashMap();

	/**
	 * wi
	 */
	transient private String	_background = null;

	/**
	 * m肵wi
	 */
	private String	_committedBackground = null;

	/**
	 * wi摜
	 */
	transient private Image	_backgroundImage = null;

	/**
	 * wiF
	 */
	transient private Color	_backgroundColor = null;

	/**
	 * m肵wiF
	 */
	private Color	_committedBackgroundColor = null;

	/**
	 * XCh
	 */
	transient private String	_slide = null;

	/**
	 * m肵XCh
	 */
	private String	_committedSlide = null;

	/**
	 * XCh摜
	 */
	transient private Image	_slideImage = null;


	/**
	 * <code>Stage</code> ̃CX^X쐬܂B
	 */
	public Stage()
	{
		super();
	}


	/**
	 * l𕑑ɓoꂳ܂B
	 * @param	actor	l
	 */
	public void enter( Actor actor )
	{
		_actors.put( actor.getName(), actor );
	}

	/**
	 * l擾܂B
	 */
	public Actor getName( String name )
	{
		return (Actor)_actors.get( name );
	}

	/**
	 * l𕑑䂩ޏꂳ܂B
	 */
	public Actor exit( String name )
	{
		Actor	actor = (Actor)_actors.remove( name );
		if( actor != null )	{
			actor.disposeLooks();
		}
		return actor;
	}

	/**
	 * SĂ̐l𕑑䂩ޏꂳ܂B
	 */
	public void exitAll()
	{
		String[]	names = (String[])_actors.keySet().toArray( new String[_actors.size()] );
		for( int i = 0; i < names.length; ++i )	{
			exit( names[i] );
		}
	}

	/**
	 * l擾܂B
	 */
	public Actor getActor( String name )
	{
		return (Actor)_actors.get( name );
	}

	/**
	 * lXg擾܂B
	 */
	public Map getActors()
	{
		return _actors;	//	N[jOǂH
	}

	/**
	 * wi摜ݒ肵܂B̃\bhĂяoƁAwiF null ɐݒ肳܂B
	 * @param	image	wi摜
	 */
	public void setBackgroundImage( String image )
	{
		ImageManager	images = ImageManager.getInstance();
		if( (_backgroundImage != null) && !_background.equals(image)  )	{
			images.putImage( _background, _backgroundImage );
			_backgroundImage = null;
		}

		Image	background = images.getImage( image );
		if( background != null )	{
			_backgroundImage = background;
			_background = image;
			_backgroundColor = null;
		}
		else if( background == null )	{
			Logger.error( "[canvas.stage] invalid background-image :" + image );
			_backgroundColor = Color.black;
			_background = "black";
		}
	}

	/**
	 * wi摜擾܂B
	 * @return	wi摜
	 */
	public Image getBackgroundImage()
	{
		return _backgroundImage;
	}

	/**
	 * wiFݒ肵܂B̃\bhĂяoƁAwi摜 null ɐݒ肳܂B
	 * @param	color	wiF
	 */
	public void setBackgroundColor( String color )
	{
		if( _backgroundImage != null )	{
			ImageManager	images = ImageManager.getInstance();
			images.putImage( _background, _backgroundImage );
			_backgroundImage = null;
		}
		ColorManager	colors = ColorManager.getInstance();
		_backgroundColor = colors.getColor( color );
		_background = color;
	}

	/**
	 * wiF擾܂B
	 * @return	wiF
	 */
	public Color getBackgroundColor()
	{
		return _backgroundColor;
	}

	/**
	 * XCh\܂B
	 * @param	slide	XCh
	 */
	public void showSlide( String slide )
	{
		ImageManager	images = ImageManager.getInstance();
		if( (_slide != null) && !_slide.equals(slide) )	{
			images.putImage( _slide, _slideImage );
		}
		_slideImage = images.getImage( slide );
		_slide = slide;
	}

	/**
	 * XChB܂B
	 */
	public void hideSlide()
	{
		if( _slideImage != null )	{
			ImageManager	images = ImageManager.getInstance();
			images.putImage( _slide, _slideImage );
		}
		_slide = null;
		_slideImage = null;
	}

	/**
	 * XCh擾܂B
	 * @return	XCh
	 */
	public String getSlide()
	{
		return _slide;
	}

	/**
	 * XCh摜擾܂B
	 * @return	XCh摜
	 */
	public Image getSlideImage()
	{
		return _slideImage;
	}

	/**
	 * BGM Đ܂B
	 * @param	id	BGM ID
	 * @param	clipName	Nbv
	 * @param	loop	[vꍇ <code>true</code>AȂꍇ <code>false</code>
	 */
	public void playBGM( String id, String clipName, boolean loop )
	{
		_audioPlayer.playBGM( id, clipName, loop );
	}

	/**
	 * BGM ~܂B
	 * @param	id	~ BGM  ID
	 */
	public void stopBGM( String id )
	{
		_audioPlayer.stop( id );
	}

	/**
	 * SE ~܂B
	 * @param	id	~ SE  ID
	 */
	public void stopSE( String id )
	{
		_audioPlayer.stop( id );
	}

	/**
	 * SE Đ܂B
	 * @param	id	SE ID
	 * @param	clipName	Nbv
	 * @param	loop	[vꍇ <code>true</code>AȂꍇ <code>false</code>
	 */
	public void playSE( String id, String clipName, boolean loop )
	{
		_audioPlayer.playSE( id, clipName, loop );
	}

	/**
	 * TEhʂI[fBIv[[ݒ肵܂B
	 * @param	audioPlayer	I[fBIv[[
	 */
	public void setAudioPlayer( AudioPlayer audioPlayer )
	{
		_audioPlayer = audioPlayer;
	}

	/**
	 * TEhʂI[fBIv[[擾܂B
	 * @return	I[fBIv[[
	 */
	public AudioPlayer getAudioPlayer()
	{
		return _audioPlayer;
	}

	/**
	 * ̃Xe[W`悷LoXݒ肵܂B
	 * @param	canvas	̃Xe[W`悷LoX
	 */
	void setStageCanvas( StageCanvas canvas )
	{
		_canvas = canvas;
	}

	/**
	 * ̃Xe[W`悷LoX擾܂B
	 * @return	Xe[WLoX
	 */
	public StageCanvas getStageCanvas()
	{
		return _canvas;
	}

	/**
	 * ̃Xe[W`悵ĂLoXŐV̏ԂɍXV܂B
	 */
	public void updateCanvas()
	{
		_canvas.updateCanvas( null );
	}

	/**
	 * ̃Xe[W`悵ĂLoXŐV̏ԂɍXV܂B
	 */
	public void updateCanvas( String effect )
	{
		if( _canvas != null )	{
			Logger.debug( "[canvas.stage] effect :" + effect );
			_canvas.updateCanvas( effect );
		}
	}


	public void commit()
	{
		_committedActors.clear();
		_committedActors.putAll( _actors );
		_committedBackground = _background;
		_committedBackgroundColor = _backgroundColor;
		_committedSlide = _slide;
	}

	/**
	 * Stage j܂B
	 */
	void dispose()
	{
		Iterator	itr = _actors.values().iterator();
		while( itr.hasNext() )	{
			((Actor)itr.next()).disposeLooks();
		}

		if( _backgroundImage != null )	{
			ImageManager	images = ImageManager.getInstance();
			images.putImage( _background, _backgroundImage );
		}

		_audioPlayer.stopAll();
	}

	/**
	 * Stage `悷鏀s܂B
	 */
	public void prepare()
	{
		if( _actors == null )	{
			_actors = (Map)_committedActors.clone();
		}

		Iterator	itr = _actors.values().iterator();
		while( itr.hasNext() )	{
			((Actor)itr.next()).prepare();
		}

		if( _committedBackgroundColor == null )	{
			setBackgroundImage( _committedBackground );
		}
		else	{
			_background = _committedBackground;
			_backgroundColor = _committedBackgroundColor;
		}

		if( _committedSlide != null )	{
			showSlide( _committedSlide );
		}

		updateCanvas();
	}
}
