/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: ImageManager.java,v 1.1.2.1 2003/12/11 10:23:10 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.stage;

import	java.awt.Image;
import	java.awt.Toolkit;

import	java.awt.image.BufferedImage;
import	java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

import	java.io.IOException;

import	java.net.URL;

import	javax.imageio.ImageIO;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.resource.ResourceManager;


/**
 * 摜f[^Ǘ@\񋟂܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class ImageManager	{

	/**
	 * B̃CX^X
	 */
	private static ImageManager	_instance = null;


	/**
	 * <code>ImageManager</code> ̃CX^X쐬܂B
	 */
	protected ImageManager()
	{
		super();
	}


	/**
	 * 摜LbV擾܂BLbVɂȂꍇ͐VKɃ[h܂B
	 * @param	name	摜
	 * @return	摜f[^
	 */
	public Image getImage( String name )
	{
		return getImage( name, false );
	}

	/**
	 * 摜LbV擾܂BLbVɂȂꍇ͐VKɃ[h܂B
	 * @param	name	摜
	 * @return	摜f[^
	 */
	public Image getImage( String name, boolean transparentize )
	{
		Image	image = null;

		BufferedImage	source = null;
		try	{
			source = ImageIO.read( getURL(name) );
		}
		catch( IOException ioe )	{
			Logger.debug( "[canvas.stage] fail to load image :" + name, ioe );
			return null;
		}

		if( transparentize )	{
			int	transColor = source.getRGB( 0, 0 );
			if( (transColor & 0xFF000000) != 0 )	{
				TransparencyRGBImageFilter	filter = new TransparencyRGBImageFilter();
				filter.setTransparencyColor( (transColor & 0x00FFFFFF) );
				FilteredImageSource	imageSource = new FilteredImageSource( source.getSource(), filter );
				image = Toolkit.getDefaultToolkit().createImage( imageSource );
				source.flush();
			}
			else	{
				image = source;
			}
		}
		else	{
			image = source;
		}
		return image;
	}

	/**
	 * 摜LbVɖ߂܂B
	 */
	public void putImage( String name, Image image )
	{
		if( image != null )	{
			image.flush();
		}
	}

	/**
	 * 摜 URL ɕϊ܂B
	 * @param	摜
	 * @return	摜t@C URL
	 */
	protected URL getURL( String name )
	{
		ResourceManager	resources = ResourceManager.getInstance();
		try	{
			return new URL( resources.getLocationResources().getImagesDirecotryURL(), name );
		}
		catch( Exception e )	{
			Logger.error( "[scene.stage] fatal error!", e );
			return null;
		}
	}


	/**
	 * B <code>ImageManager</code> CX^X擾܂B
	 * @return	<code>ImageManager</code> CX^X
	 */
	public static ImageManager getInstance()
	{
		if( _instance == null )	{
			synchronized( ImageManager.class )	{
				if( _instance == null )	{
					_instance = new ImageManager();
				}
			}
		}
		return _instance;
	}
}



class TransparencyRGBImageFilter	extends RGBImageFilter	{

	/**
	 * F(ftHgF#00FF00)
	 */
	private int	_transparencyColor = 0x0000FF00;

	/**
	 * <code>TransparencyRGBImageFilter</code> ̃CX^X𐶐܂B
	 */
	TransparencyRGBImageFilter()
	{
		super();
	}


	public void setTransparencyColor( int transColor )
	{
		_transparencyColor = transColor;
	}

	public int getTransparencyColor()
	{
		return _transparencyColor;
	}


//
//	RGBImageFilter ̎
//
	public int filterRGB( int x, int y, int rgb )
	{
		if( (rgb & 0x00FFFFFF) == _transparencyColor )	{
			return (0x00FFFFFF & rgb);
		}
		else	{
			return rgb;
		}
	}
}