/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: AudioClip.java,v 1.1.2.1 2003/12/11 10:23:10 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.stage;

import	java.net.URL;


/**
 * yNbv̊{Iȋ@\񋟂܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public abstract class AudioClip	{

	/**
	 * Nbv ID
	 */
	private String	_id = null;

	/**
	 * ̃NbvǗ AudioPlayer
	 */
	private AudioPlayer	_player = null;

	/**
	 * ĐNbv URL
	 */
	private URL	_clipURL = null;

	/**
	 * [v邩ǂ
	 */
	private boolean	_isLoop = false;


	/**
	 * <code>AudioClip</code> ̃CX^X쐬邽߂ɃTuNX̃RXgN^Ă΂܂B
	 * @param	id	Nbv ID
	 * @param	clipURL	Nbv URL
	 */
	protected AudioClip( String id, URL clipURL )
	{
		super();
		_id = id;
		_clipURL = clipURL;
	}


	/**
	 * ̃NbṽNbv ID 擾܂B
	 * @return	Nbv ID
	 */
	public String getID()
	{
		return _id;
	}

	/**
	 * ̃NbvǗ AudioPlayer ݒ肵܂B
	 * @param	player	̃NbvǗ AudioPlayer
	 */
	public void setAudioPlayer( AudioPlayer player )
	{
		_player = player;
	}

	/**
	 * ̃NbvǗ AudioPlayer 擾܂B
	 * @return	̃NbvǗ AudioPlayer
	 */
	public AudioPlayer getAudioPlayer()
	{
		return _player;
	}

	/**
	 * ̃Nbṽ\[Xf[^ URL 擾܂B
	 * @return	̃Nbṽ\[Xf[^ URL
	 */
	public URL getClipURL()
	{
		return _clipURL;
	}

	/**
	 * ̃Nbv̍Đ[v邩ǂ𔻒肵܂B
	 * @return	[vꍇ <code>true</code>AȂꍇ <code>false</code>
	 */
	public boolean isLoop()
	{
		return _isLoop;
	}

	/**
	 * ̃NbvĐJn܂B
	 * @param	loop	[vꍇ <code>true</code>AȂꍇ <code>false</code>B
	 */
	public void play( boolean loop )
	{
		_isLoop = loop;
		play();
	}

	/**
	 * ̃Nbv̍ĐJn܂B
	 */
	public abstract void play();

	/**
	 * ̃Nbv̍Đ~܂B
	 */
	public abstract void stop();

	/**
	 * tIƂ AudioPlayer ɒʒm܂B
	 */
	protected void playingFinished()
	{
		AudioPlayer	player = getAudioPlayer();
		if( player != null )	{
			player.unregister( this );
		}
	}
}
