/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: SelectCanvas.java,v 1.1.2.1 2003/12/11 10:23:24 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.select;

import	java.awt.Dimension;

import	java.awt.event.KeyEvent;
import	java.awt.event.KeyListener;

import	java.util.List;
import	java.util.Map;

import	javax.swing.JComponent;

import	tsukuba_bunko.peko.ActionControler;
import	tsukuba_bunko.peko.Logger;
import	tsukuba_bunko.peko.PekoSystem;


/**
 * I\LoXłB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class SelectCanvas	extends JComponent	implements KeyListener	{

	/**
	 * {^̈ʒuF
	 */
	public static final int	ALIGN_LEFT = 0;

	/**
	 * {^̈ʒuF
	 */
	public static final int	ALIGN_CENTER = 1;

	/**
	 * {^̈ʒuFE
	 */
	public static final int	ALIGN_RIGHT = 2;

	/**
	 * {^̈ʒuF
	 */
	public static final int	VALIGN_TOP = 0;

	/**
	 * {^̈ʒuF
	 */
	public static final int	VALIGN_MIDDLE = 1;

	/**
	 * {^̈ʒuF
	 */
	public static final int	VALIGN_BOTTOM = 2;


	/**
	 * LtO
	 */
	private boolean	_active = false;

	/**
	 * IXg
	 */
	private List	_buttons = null;

	/**
	 * Iꂽ ID
	 */
	private String	_id = null;

	/**
	 * ݑI𒆂̃{^
	 */
	private SelectItemButton	_selected = null;

	/**
	 * ݑI𒆂̃{^̃CfbNX
	 */
	private int	_selectedIndex = -1;


	/**
	 * ŌɉꂽL[̃L[R[h
	 */
	private int	_lastKeyCode = -1;


	/**
	 * I{^̔zuʒu
	 */
	private int	_align = SelectCanvas.ALIGN_CENTER;

	/**
	 */
	private int	_verticalAlign = SelectCanvas.VALIGN_TOP;

	/**
	 * I̗
	 */
	private int	_columns = 1;

	/**
	 * 
	 */
	private int	_columnSpan = 20;

	/**
	 * s
	 */
	private int	_rowSpan = 20;

	/**
	 * Eƃ[gLoX̘gƂ̊
	 */
	private int	_boundSpan = 20;

	/**
	 * {^X^C}bv
	 */
	private Map	_buttonStyle = null;

	/**
	 * Dimension cache
	 */
	private Dimension	_dimensionCache = null;


	/**
	 * <code>SelectCanvas</code> ̃CX^X쐬܂B
	 */
	public SelectCanvas()
	{
		super();
	}


	/**
	 * I{^̔zuʒuݒ肵܂Bݒ肵éAIw\甽f܂B
	 * @param	align	zuʒu
	 * @throws	IllegalArgumentException	align  {@link SelectCanvas#ALIGN_CENTER} ܂ {@link SelectCanvas#ALIGN_LEFT} ܂ {@link SelectCanvas#ALIGN_RIGHT} ȊȌꍇB
	 */
	public void setAlignment( int align )
	{
		if( (align == SelectCanvas.ALIGN_CENTER) || (align == SelectCanvas.ALIGN_LEFT) || (align == SelectCanvas.ALIGN_RIGHT) )	{
			_align = align;
		}
		else	{
			throw new IllegalArgumentException( "invalid alignment type is specified." );
		}
	}

	/**
	 * I{^̔zuʒu擾܂B
	 * @return	I{^̔zuʒu
	 */
	public int getAlignment()
	{
		return _align;
	}

	/**
	 * I{^̐̔zuʒuݒ肵܂B
	 * @param	valign	zuʒu
	 * @throws	IllegalArgumentException	align  {@link SelectCanvas#VALIGN_TOP} ܂ {@link SelectCanvas#VALIGN_MIDDLE} ܂ {@link SelectCanvas#VALIGN_BOTTOM} ȊȌꍇB
	 */
	public void setVerticalAlignment( int valign )
	{
		if( (valign == SelectCanvas.ALIGN_CENTER) || (valign == SelectCanvas.ALIGN_LEFT) || (valign == SelectCanvas.ALIGN_RIGHT) )	{
			_verticalAlign = valign;
		}
		else	{
			throw new IllegalArgumentException( "invalid vertical alignment type is specified." );
		}
	}

	/**
	 * I{^̐̔zuʒu擾܂B
	 * @return	I{^̔zuʒu
	 */
	public int getVericalAlignment()
	{
		return _verticalAlign;
	}

	/**
	 * I{^̗񐔂ݒ肵܂Bݒ肵éAIw\甽f܂B
	 * @param	columns 
	 * @throws	IllegalArgumentException	<code>columns <= 0</code> ̏ꍇ
	 */
	public void setColumns( int columns )
	{
		_columns = columns;
	}

	/**
	 * I{^̗񐔂擾܂B
	 * @return	I{^̗
	 */
	public int getColumns()
	{
		return _columns;
	}

	/**
	 * Ԃݒ肵܂Bݒ肵éAIw\甽f܂B
	 * @param	span	Ԃ̒
	 */
	public void setColumnSpan( int span )
	{
		_columnSpan = span;
	}

	/**
	 * Ԃ擾܂B
	 * @return	Ԃ̒
	 */
	public int getColumnSpan()
	{
		return _columnSpan;
	}

	/**
	 * sԂݒ肵܂Bݒ肵éAIw\甽f܂B
	 * @param	span	sԂ̒
	 */
	public void setRowSpan( int span )
	{
		_rowSpan = span;
	}

	/**
	 * sԂ擾܂B
	 * @return	sԂ̒
	 */
	public int getRowSpan()
	{
		return _rowSpan;
	}

	/**
	 * Ï̋Eƃ[gLoX̘gƂ̊Ԃݒ肵܂Bݒ肵éAIw\甽f܂B
	 * @param	span	sԂ̒
	 */
	public void setBoundSpan( int span )
	{
		_boundSpan = span;
	}

	/**
	 * Ï̋Eƃ[gLoX̘gƂ̊Ԃ擾܂B
	 * @return	sԂ̒
	 */
	public int getBoundSpan()
	{
		return _boundSpan;
	}

	/**
	 * I{^̃X^Cݒ肵܂Bݒ肵éAIw\甽f܂B
	 * @param	styles	I{^̃X^C}bv
	 */
	public void setButtonStyle( Map styles )
	{
		_buttonStyle = styles;
	}

	/**
	 * I{^̃X^C擾܂B
	 * @return	I{^̃X^C
	 */
	public Map getButtonStyle()
	{
		return _buttonStyle;
	}

	/**
	 * I\A[U[II ID 擾܂B
	 * @param	selectItems	I
	 * @param	canvas	IzuLoX
	 * @return	IꂽI ID
	 */
	public String select( List selectItems )
	{
		return select( selectItems, -1 );
	}

	/**
	 * I\A[U[II ID 擾܂B
	 * @param	selectItems	I
	 * @param	timeout	^CAEg܂ł̎[ms]
	 * @return	IꂽI ID
	 */
	public String select( List selectItems, long timeout )
	{
		if( _buttonStyle == null )	{
			throw new IllegalStateException( "button styles is not specified." );
		}

		if( _active )	{
			Logger.debug( "[canvas.select] already show selection." );
			return null;
		}

		synchronized( this )	{
			_id = null;

			Dimension	canvasSize = getSize( _dimensionCache );

			int	size = selectItems.size();
			int	buttonWidth = 320;
			Integer	intValue = (Integer)_buttonStyle.get( SelectItemButton.STYLE_WIDTH );
			if( intValue != null )	{
				buttonWidth = intValue.intValue();
			}

			setVisible( false );

			SelectItem	item = null;
			SelectItemButton	button = null;
			List	buttons = new java.util.ArrayList( size );
			int	x = 0;
			int	y = 0;
			int	rowHeight = 0;
			Dimension	buttonSize = new Dimension( 0, 0 );
			for( int i = 0; i < size; ++i )	{
				if( (i % _columns) == 0 )	{
					y += rowHeight;
					if( item != null )	{
						y += _rowSpan;
					}
					x = 0;
					rowHeight = 0;
				}
				else	{
					x += (buttonSize.width + _columnSpan);
				}

				item = (SelectItem)selectItems.get( i );
				button = new SelectItemButton( this );
				button.setSelectItem( item );
				button.prepare( _buttonStyle );
				buttons.add( button );

				add( button );
				button.setLocation( x, y );
				buttonSize = button.getSize( buttonSize );
				if( buttonSize.height > rowHeight )	{
					rowHeight = buttonSize.height;
				}
			}

			int	areaWidth = (buttonWidth * _columns) + (_columnSpan * (_columns - 1));
			int	leftPosition = 0;
			if( areaWidth > canvasSize.width )	{
				leftPosition = 0;
			}
			else if( (areaWidth + _boundSpan) > canvasSize.width )	{
				leftPosition = (canvasSize.width - areaWidth) / 2;
			}
			else if( _align == SelectCanvas.ALIGN_CENTER )	{
				leftPosition = (canvasSize.width - areaWidth) / 2;
			}
			else if( _align == SelectCanvas.ALIGN_LEFT )	{
				leftPosition = _boundSpan;
			}
			else if( _align == SelectCanvas.ALIGN_RIGHT )	{
				leftPosition = canvasSize.width - areaWidth - _boundSpan;
			}

			int	areaHeight = y + rowHeight;
			int	topPosition = 0;
			if( areaHeight > canvasSize.height )	{
				topPosition = 0;
			}
			else if( (areaHeight + _boundSpan) > canvasSize.height )	{
				topPosition = (canvasSize.height - areaHeight) / 2;
			}
			else if( _verticalAlign == SelectCanvas.VALIGN_TOP )	{
				topPosition = _boundSpan;
			}
			else if( _verticalAlign == SelectCanvas.VALIGN_MIDDLE )	{
				topPosition = (canvasSize.height - areaHeight) / 2;
			}
			else if( _verticalAlign == SelectCanvas.VALIGN_BOTTOM )	{
				topPosition = canvasSize.height - areaHeight - _boundSpan;
			}
			setLocation( leftPosition, topPosition );

			_buttons = buttons;
			_active = true;

			setVisible( true );
		}

		Logger.debug( "[canvas.select] wait for selecting." );
		ActionControler	controler = PekoSystem.getInstance().getActionControler();
		if( timeout > 0 )	{
			controler.stop( timeout );
		}
		else	{
			controler.stop();
		}

		synchronized( this )	{
			int	size = _buttons.size();
			for( int i = 0; i < size; ++i )	{
				remove( (SelectItemButton)_buttons.get(i) );
			}
			_buttons.clear();
			_buttons = null;
		}

		Logger.debug( "[canvas.select] id: " + _id );
		return _id;
	}

	/**
	 * ȊI҂܂B
	 */
	public void cancel()
	{
		_active = false;
		synchronized( this )	{
			if( _buttons != null )	{
				_id = null;
				ActionControler	controler = PekoSystem.getInstance().getActionControler();
				controler.start();
				Logger.debug( "[cenvas.select] canceled." );
			}
		}
	}


//
//	ICxg
//
	/**
	 * <code>button</code> IԂɂȂ܂B
	 * @param	button	IԂɂȂ SelectItemButton CX^X
	 */
	public void itemSelecting( SelectItemButton button )
	{
		SelectItemButton	old = _selected;
		_selected = button;
		if( (old != null) && (old != button) )	{
			old.setSelected( false );
		}
		_selectedIndex = _buttons.indexOf( button );
	}

	/**
	 * <code>button</code> IԂɂȂ܂
	 * @param	button	IԂɂȂ SelectItemButton CX^X
	 */
	public void itemDeselected( SelectItemButton button )
	{
		if( _selected == button )	{
			_selected = null;
			_selectedIndex = -1;
		}
	}

	/**
	 * <code>button</code> I܂B
	 * @param	button	Iꂽ SelectItemButton CX^X
	 */
	public void itemSelected( SelectItemButton button )
	{
		if( _active )	{
			synchronized( this )	{
				if( _active )	{
					_selected = null;
					_selectedIndex = -1;
					_id = button.getSelectItem().getID();
					_active = false;
					Logger.debug( "[canvas.select] selected: " + _id );
					ActionControler	controler = PekoSystem.getInstance().getActionControler();
					controler.start();
				}
			}
		}
	}


//
//	KeyListener ̎
//
	public void keyPressed( KeyEvent ev )
	{
		if( _active )	{
			int	code = ev.getKeyCode();
			if( _lastKeyCode == -1 )	{
				_lastKeyCode = code;
			}
			else if( _lastKeyCode != code )	{
				_lastKeyCode = -1;
			}

			int	index = _selectedIndex;
			int	size = _buttons.size();

			if( code == KeyEvent.VK_DOWN )	{
				index = (index + 1) % size;
			}
			else if( (code == KeyEvent.VK_RIGHT) && (_columns > 1) )	{
				index = (index + 1) % size;
			}
			else if( code == KeyEvent.VK_UP )	 {
				index--;
				if( index < 0 )	{
					index = _buttons.size() -1 ;
				}
			}
			else if( (code == KeyEvent.VK_LEFT) && (_columns > 1) )	{
				index--;
				if( index < 0 )	{
					index = _buttons.size() -1 ;
				}
			}
			else	{
				return;
			}
			SelectItemButton	button = (SelectItemButton)_buttons.get( index );
			button.setSelected( true );
		}
	}

	public void keyReleased( KeyEvent ev )
	{
		if( !_active || (_buttons == null) )	{
			return;
		}

		int	code = ev.getKeyCode();
		if( code != _lastKeyCode )	{
			_lastKeyCode = -1;
			return;
		}

		if( (code == KeyEvent.VK_ENTER) && (_selected != null) )	{
			itemSelected( _selected );
		}
		_lastKeyCode = -1;
	}

	public void keyTyped( KeyEvent ev )
	{
	}
}
