/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * (c) Copyright 2002 by Tsukuba Bunko.
 *
 * $Id: MessageID.java,v 1.1.2.1 2003/12/11 10:09:11 ppoi Exp $
 */
package tsukuba_bunko.peko;

import	java.text.MessageFormat;

import	tsukuba_bunko.peko.resource.ResourceManager;


/**
 * bZ[W ID łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class MessageID	{

	/**
	 * bZ[W\[X prefix
	 */
	public static final String	RID_PREFIX = "peko.message.";

	/**
	 * o̓bZ[W̃ev[g / {0}:bZ[W ID {1}:bZ[W
	 */
	protected static final MessageFormat	TEMPLATE_MESSAGE = new MessageFormat( "[{0}] {1}" );

	/**
	 * bZ[W\[X݂Ȃꍇ̃bZ[W
	 */
	protected static final String	NULL_MESSAGE = "********** NO MESSAGE **********";


	/**
	 * bZ[W ID
	 */
	private String	_messageID = null;

	/**
	 * ftHg̃bZ[W
	 */
	private Object	_defaultMessage = null;


	/**
	 * <code>MessageID</code> ̃CX^X𐶐܂B
	 * @param	messageID	bZ[W ID
	 */
	public MessageID( String messageID )
	{
		this( messageID, "***** message missing *****" );
	}

	/**
	 * <code>MessageID</code> ̃CX^X𐶐܂B
	 * @param	messageID	bZ[W ID
	 * @param	defaultMessage	ftHg̃bZ[W
	 */
	public MessageID( String messageID, Object defaultMessage )
	{
		super();
		_messageID = messageID;
		_defaultMessage = defaultMessage;
	}


	/**
	 * bZ[W ID 擾܂B
	 * @return	bZ[W ID
	 */
	public String getMessageID()
	{
		return _messageID;
	}

	/**
	 * bZ[W擾܂B
	 * @return	bZ[W
	 */
	public String getMessage()
	{
		ResourceManager	resources = ResourceManager.getInstance();
		Object	message = null;
		if( _defaultMessage == null )	{
			message = resources.getResource( MessageID.RID_PREFIX + _messageID );
			if( message == null )	{
				message = MessageID.NULL_MESSAGE;
			}
		}
		else	{
			message = resources.getResource( MessageID.RID_PREFIX + _messageID, true );
			if( message == null )	{
				message = _defaultMessage;
			}
		}

		String	messageStr = null;
		if( message instanceof String )	{
			messageStr = (String)message;
		}
		else	{
			messageStr = message.toString();
		}

		return MessageID.TEMPLATE_MESSAGE.format( new Object[]{_messageID, messageStr} );
	}

	/**
	 * bZ[W擾܂B
	 * @param	params	bZ[Wɖߍރp[^
	 * @return	bZ[W
	 */
	public String getMessage( Object[] params )
	{
		ResourceManager	resources = ResourceManager.getInstance();
		Object	message = null;
		if( _defaultMessage == null )	{
			message = resources.getResource( MessageID.RID_PREFIX + _messageID );
			if( message == null )	{
				message = MessageID.NULL_MESSAGE;
			}
		}
		else	{
			message = resources.getResource( MessageID.RID_PREFIX + _messageID, true );
			if( message == null )	{
				message = _defaultMessage;
			}
		}

		String	messageStr = null;
		if( message instanceof MessageFormat )	{
			messageStr = ((MessageFormat)message).format( params );
		}
		else if( message instanceof String )	{
			messageStr = MessageFormat.format( (String)message, params );
		}
		else	{
			messageStr = message.toString();
		}

		return MessageID.TEMPLATE_MESSAGE.format( new Object[]{_messageID, messageStr} );
	}


//
//	Object ̎
//
	public String toString()
	{
		return _messageID;
	}

	public int hashCode()
	{
		return _messageID.hashCode();
	}

	public boolean equals( Object obj )
	{
		if( obj instanceof MessageID )	{
			return _messageID.equals( ((MessageID)obj)._messageID );
		}
		else	{
			return false;
		}
	}
}