/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import tsukuba_bunko.util.InvocHandler;

public class GenericListener {
    private GenericListener() {
    }

    public static boolean connect(Object eventSource, Object eventTarget, Class listenerClass, String sourceMethod, String targetMethod) {
        return GenericListener.connect(eventSource, eventTarget, listenerClass, sourceMethod, targetMethod, false);
    }

    public static boolean connect(Object eventSource, Object eventTarget, Class listenerClass, String sourceMethod, String targetMethod, boolean newThread) {
        try {
            Method addMethod = eventSource.getClass().getMethod("add" + GenericListener.identifierOf(listenerClass), listenerClass);
            if (addMethod == null) {
                return false;
            }
            Method sourceMethodObject = GenericListener.getListenerMethod(listenerClass, sourceMethod);
            Method targetMethodObject = GenericListener.getTargetMethod(eventTarget.getClass(), targetMethod, sourceMethodObject.getParameterTypes());
            Object listenerImple = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{listenerClass}, (InvocationHandler)new InvocHandler(eventTarget, targetMethodObject, sourceMethodObject, newThread));
            addMethod.invoke(eventSource, listenerImple);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static String identifierOf(Class c) {
        String className = c.getName();
        return className.substring(className.lastIndexOf(46) + 1, className.length());
    }

    private static Method getListenerMethod(Class listenerClass, String methodName) throws NoSuchMethodException {
        Method[] methods = listenerClass.getMethods();
        int i = methods.length - 1;
        while (i >= 0) {
            if (methodName.equals(methods[i].getName())) {
                return methods[i];
            }
            --i;
        }
        throw new NoSuchMethodException("No such method \"" + methodName + "\" in \"" + listenerClass.getName() + "\".");
    }

    private static Method getTargetMethod(Class c, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        Method method = null;
        try {
            method = c.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            method = c.getDeclaredMethod(methodName, null);
        }
        try {
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return method;
    }
}

