/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.resource;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import tsukuba_bunko.resource.ResourceDeserializer;

public class DeserializerMapping {
    private Map _registry = new HashMap(89);
    static /* synthetic */ Class class$0;

    public void register(String typeName, ResourceDeserializer deserializer) {
        deserializer.setDeserializerMapping(this);
        deserializer.setTypeName(typeName);
        this._registry.put(typeName, deserializer);
    }

    public void unregister(String typeName) {
        this._registry.remove(typeName);
    }

    public ResourceDeserializer getResourceDeserializer(String dataType) {
        return (ResourceDeserializer)this._registry.get(dataType);
    }

    public static DeserializerMapping newInstance(String bundleName) {
        DeserializerMapping mapping = new DeserializerMapping();
        ResourceBundle source = ResourceBundle.getBundle(bundleName);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("tsukuba_bunko.resource.DeserializerMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader cl = clazz.getClassLoader();
        Enumeration<String> keys = source.getKeys();
        String key = null;
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            String className = source.getString(key);
            try {
                mapping.register(key, (ResourceDeserializer)cl.loadClass(className).newInstance());
            }
            catch (Exception e) {
                System.err.println("[libtbas] ERROR : illegal class \"" + className + "\"");
                e.printStackTrace();
            }
        }
        return mapping;
    }

    public static DeserializerMapping newInstance() {
        return DeserializerMapping.newInstance(System.getProperty("libtbas.resource.mapping", "tsukuba_bunko.resource.mapping"));
    }
}

