/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.session;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.resource.ColorManager;
import tsukuba_bunko.peko.resource.FontManager;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.session.MessageIDs;
import tsukuba_bunko.peko.session.SaveDataInfo;

public class SaveDataInfoRenderer
extends JComponent
implements ListCellRenderer {
    private SaveDataInfo _info = null;
    private boolean _selected = false;
    private int _index = -1;
    private Dimension _cellSize = null;
    private Color _selectedBackground = null;
    private Color _unselectedBackground = null;
    private Font _titleFont = null;
    private Color _titleColor = null;
    private Font _timestampFont = null;
    private Color _timestampColor = null;
    private Font _commentFont = null;
    private Color _commentColor;
    private MessageFormat _titleFormat = null;
    private SimpleDateFormat _timestampFormat = null;
    private String _nodataTitle = null;

    public SaveDataInfoRenderer() {
        String timestampFormat;
        HashMap<TextAttribute, Object> attributes;
        ResourceManager resources = ResourceManager.getInstance();
        ColorManager colors = ColorManager.getInstance();
        FontManager fonts = FontManager.getInstance();
        Dimension size = (Dimension)resources.getResource("peko.savedata-chooser.cell.size");
        if (size == null) {
            Logger.warn(MessageIDs.SAV0009W, new Object[]{"380,65"});
            size = new Dimension(380, 65);
        }
        this.setPreferredSize(size);
        this.setSize(size);
        this._cellSize = size;
        this._selectedBackground = (Color)resources.getResource("peko.savedata-chooser.cell.background.selected");
        if (this._selectedBackground == null) {
            this._selectedBackground = colors.getColor("#FF88FF");
            Logger.warn(MessageIDs.SAV0024W, new Object[]{"cell.background.selected", "#FF88FF"});
        }
        this._unselectedBackground = (Color)resources.getResource("peko.savedata-chooser.cell.background.unselected");
        if (this._unselectedBackground == null) {
            this._unselectedBackground = colors.getColor("white");
            Logger.warn(MessageIDs.SAV0024W, new Object[]{"cell.background.unselected", "white"});
        }
        this._titleColor = (Color)resources.getResource("peko.savedata-chooser.cell.title.color");
        if (this._titleColor == null) {
            this._titleColor = colors.getColor("black");
            Logger.warn(MessageIDs.SAV0023W, new Object[]{"cell.title", "black"});
        }
        this._timestampColor = (Color)resources.getResource("peko.savedata-chooser.cell.timestamp.color");
        if (this._timestampColor == null) {
            this._timestampColor = colors.getColor("black");
            Logger.warn(MessageIDs.SAV0023W, new Object[]{"cell.timestamp", "black"});
        }
        this._commentColor = (Color)resources.getResource("peko.savedata-chooser.cell.comment.color");
        if (this._commentColor == null) {
            this._commentColor = colors.getColor("black");
            Logger.warn(MessageIDs.SAV0023W, new Object[]{"cell.comment", "black"});
        }
        this._titleFont = (Font)resources.getResource("peko.savedata-chooser.cell.title.font");
        if (this._titleFont == null) {
            Logger.warn(MessageIDs.SAV0010W, new Object[]{"cell.title", "family:SansSerif; size:16.0; style:normal; weight:bold"});
            attributes = new HashMap<TextAttribute, Object>();
            attributes.put(TextAttribute.FAMILY, "SansSerif");
            attributes.put(TextAttribute.SIZE, new Float(16.0f));
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            this._titleFont = fonts.getFont(attributes);
        }
        this._timestampFont = (Font)resources.getResource("peko.savedata-chooser.cell.timestamp.font");
        if (this._timestampFont == null) {
            Logger.warn(MessageIDs.SAV0010W, new Object[]{"cell.timestamp", "family:SansSerif; size:11.0; style:normal; weight:normarl"});
            attributes = new HashMap();
            attributes.put(TextAttribute.FAMILY, "SansSerif");
            attributes.put(TextAttribute.SIZE, new Float(11.0f));
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            this._timestampFont = fonts.getFont(attributes);
        }
        this._commentFont = (Font)resources.getResource("peko.savedata-chooser.cell.comment.font");
        if (this._timestampFont == null) {
            Logger.warn(MessageIDs.SAV0010W, new Object[]{"cell.comment", "family:SansSerif; size:16.0; style:normal; weight:normarl"});
            attributes = new HashMap();
            attributes.put(TextAttribute.FAMILY, "SansSerif");
            attributes.put(TextAttribute.SIZE, new Float(11.0f));
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            this._commentFont = fonts.getFont(attributes);
        }
        this._titleFormat = (MessageFormat)resources.getResource("peko.savedata-chooser.cell.title-format");
        if (this._titleFormat == null) {
            this._titleFormat = new MessageFormat("No.{0}  {1}");
            Logger.warn(MessageIDs.SAV0011W, new Object[]{"\"No.{0}  {1}\""});
        }
        if ((timestampFormat = (String)resources.getResource("peko.savedata-chooser.cell.timestamp-format")) == null) {
            timestampFormat = "yyyy/MM/dd hh:mm";
            Logger.warn(MessageIDs.SAV0017W, new Object[]{"\"" + timestampFormat + "\""});
        }
        this._timestampFormat = new SimpleDateFormat(timestampFormat);
        this._nodataTitle = (String)resources.getResource("peko.savedata-chooser.cell.no-data-title");
        if (this._nodataTitle == null) {
            this._nodataTitle = "-NO DATA-";
            Logger.warn(MessageIDs.SAV0018W, new Object[]{"\"" + this._nodataTitle + "\""});
        }
    }

    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        if (this._selected) {
            g.setColor(this._selectedBackground);
        } else {
            g.setColor(this._unselectedBackground);
        }
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(Color.black);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        float y = 3.0f;
        AttributedString as = null;
        TextLayout layout = null;
        if (this._info == null) {
            as = new AttributedString(this._titleFormat.format(new Object[]{String.valueOf(this._index + 1), this._nodataTitle}));
            as.addAttribute(TextAttribute.FONT, this._titleFont);
            as.addAttribute(TextAttribute.FOREGROUND, this._titleColor);
            layout = new TextLayout(as.getIterator(), g2.getFontRenderContext());
            layout.draw(g2, 5.0f, layout.getAscent() + y);
            y += layout.getAscent() + layout.getDescent() + 5.0f;
        } else {
            as = new AttributedString(this._titleFormat.format(new Object[]{String.valueOf(this._index + 1), this._info.getTitle()}));
            as.addAttribute(TextAttribute.FONT, this._titleFont);
            as.addAttribute(TextAttribute.FOREGROUND, this._titleColor);
            layout = new TextLayout(as.getIterator(), g2.getFontRenderContext());
            layout.draw(g2, 5.0f, layout.getAscent() + y);
            y += layout.getAscent() + layout.getDescent() + 5.0f;
            as = new AttributedString(this._timestampFormat.format(this._info.getTimestamp()));
            as.addAttribute(TextAttribute.FONT, this._timestampFont);
            as.addAttribute(TextAttribute.FOREGROUND, this._timestampColor);
            layout = new TextLayout(as.getIterator(), g2.getFontRenderContext());
            layout.draw(g2, 5.0f, layout.getAscent() + y);
            y += layout.getAscent() + layout.getDescent() + 5.0f;
            if (this._info.getComment() != null) {
                as = new AttributedString(this._info.getComment());
                as.addAttribute(TextAttribute.FONT, this._commentFont);
                as.addAttribute(TextAttribute.FOREGROUND, this._commentColor);
                layout = new TextLayout(as.getIterator(), g2.getFontRenderContext());
                layout.draw(g2, 5.0f, layout.getAscent() + y);
            }
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasForcus) {
        this._info = (SaveDataInfo)value;
        this._selected = isSelected;
        this._index = index;
        this.setBorder(BorderFactory.createEtchedBorder(1));
        return this;
    }
}

