/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.session.MessageIDs;
import tsukuba_bunko.peko.session.SaveDataInfo;
import tsukuba_bunko.peko.session.SaveDataInfoRenderer;

public class SaveDataDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static final boolean FOR_SAVE = true;
    public static final boolean FOR_LOAD = false;
    protected int _selected = -1;
    protected SaveDataInfo[] _infoList = null;
    protected JList _list = null;
    protected JButton _ok = null;
    protected JButton _cancel = null;
    protected boolean _forSave = false;
    protected SaveDataInfoRenderer _renderer = null;

    public SaveDataDialog(boolean forSave) {
        super((Frame)PekoSystem.getInstance().getMainWindow(), true);
        this._forSave = forSave;
        ResourceManager resources = ResourceManager.getInstance();
        Boolean decorated = (Boolean)resources.getResource("peko.savedata-chooser.dialog.decorated", true);
        if (decorated != null) {
            this.setUndecorated(decorated == false);
        }
        if (forSave) {
            String title = (String)resources.getResource("peko.savedata-chooser.dialog.title.save");
            if (title == null) {
                Logger.warn(MessageIDs.SAV0012W);
            } else {
                this.setTitle(title);
            }
        } else {
            String title = (String)resources.getResource("peko.savedata-chooser.dialog.title.load");
            if (title == null) {
                Logger.warn(MessageIDs.SAV0012W);
            } else {
                this.setTitle(title);
            }
        }
        this._renderer = new SaveDataInfoRenderer();
    }

    protected void initialize(SaveDataInfo[] infoList, int initialIndex) {
        ResourceManager resources = ResourceManager.getInstance();
        JList<SaveDataInfo> list = new JList<SaveDataInfo>(infoList);
        list.setAutoscrolls(true);
        list.setSelectionMode(0);
        list.setCellRenderer(this._renderer);
        list.addListSelectionListener(this);
        JScrollPane container = new JScrollPane(list);
        container.setAutoscrolls(true);
        Integer atonce = (Integer)resources.getResource("peko.savedata-chooser.items-at-once");
        if (atonce == null) {
            atonce = new Integer(5);
            Logger.warn(MessageIDs.SAV0013W, new Object[]{"5"});
        } else if (atonce <= 0) {
            atonce = new Integer(5);
            Logger.warn(MessageIDs.SAV0014W, new Object[]{"5"});
        }
        Dimension size = container.getPreferredSize();
        Dimension cellSize = this._renderer.getPreferredSize();
        size.height = cellSize.height * atonce + 5;
        container.setPreferredSize(size);
        container.setSize(size);
        Rectangle visibleRect = new Rectangle(5, cellSize.height * (initialIndex - 1), cellSize.width, cellSize.height);
        container.getViewport().scrollRectToVisible(visibleRect);
        JPanel buttons = new JPanel(new FlowLayout());
        JButton ok = new JButton();
        String caption = (String)resources.getResource("peko.savedata-chooser.button.ok");
        if (caption == null) {
            caption = "OK";
            Logger.warn(MessageIDs.SAV0019W, new Object[]{"OK", caption});
        }
        ok.setText(caption);
        ok.addActionListener(this);
        JButton cancel = new JButton();
        caption = (String)resources.getResource("peko.savedata-chooser.button.cancel");
        if (caption == null) {
            caption = "CANCEL";
            Logger.warn(MessageIDs.SAV0019W, new Object[]{"Cancel", caption});
        }
        cancel.setText(caption);
        cancel.addActionListener(this);
        buttons.add(ok);
        buttons.add(cancel);
        JPanel cp = new JPanel(new BorderLayout());
        cp.add(container);
        cp.add((Component)buttons, "South");
        this.setContentPane(cp);
        this.pack();
        this.setResizable(false);
        this._list = list;
        this._ok = ok;
        this._cancel = cancel;
        this.getRootPane().setDefaultButton(this._ok);
        this._infoList = infoList;
        list.setSelectedIndex(initialIndex);
    }

    public int getSelectedIndex() {
        return this._selected;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this._ok) {
            if (this._list.getSelectedValue() == null) {
                if (!this._forSave) return;
                this._selected = this._list.getSelectedIndex();
            } else if (this._forSave) {
                String message;
                ResourceManager resources = ResourceManager.getInstance();
                String title = (String)resources.getResource("peko.savedata-chooser.dialog.confirm.title");
                if (title == null) {
                    Logger.warn(MessageIDs.SAV0015W);
                }
                if ((message = (String)resources.getResource("peko.savedata-chooser.dialog.confirm.message")) == null) {
                    message = "Do you overwrite save data ?";
                    Logger.warn(MessageIDs.SAV0016W, new Object[]{"\"" + message + "\""});
                }
                if (JOptionPane.showConfirmDialog(this, message, title, 0) != 0) return;
                this._selected = this._list.getSelectedIndex();
            } else {
                this._selected = this._list.getSelectedIndex();
            }
        } else {
            this._selected = -1;
        }
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent ev) {
        if (this._forSave) {
            return;
        }
        int selected = this._list.getSelectedIndex();
        if (selected != -1 && this._infoList[selected] != null) {
            this._ok.setEnabled(true);
        } else {
            this._ok.setEnabled(false);
        }
    }

    public static int showDialog(SaveDataInfo[] list, int initialIndex, boolean forSave) {
        SaveDataDialog dialog = new SaveDataDialog(forSave);
        dialog.initialize(list, initialIndex);
        dialog.setLocationRelativeTo(dialog.getOwner());
        dialog.show();
        return dialog.getSelectedIndex();
    }
}

