/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.util;

import org.xml.sax.Attributes;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.ElementHandler;
import tsukuba_bunko.peko.scenario.FlagScope;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.util.MessageIDs;

public class FlagHandler
extends ElementHandler {
    private String _flagID = null;
    private FlagScope _scope = null;
    private boolean _declare = true;

    public void startDocument() {
        this._flagID = null;
        this._declare = true;
        this._scope = null;
    }

    public void endDocument() {
        if (this._flagID != null) {
            if (this._declare) {
                this.getSceneContext().declareFlag(this._flagID, this._scope);
            } else {
                this.getSceneContext().undeclareFlag(this._flagID, this._scope);
            }
        }
    }

    public void startElement(String namespaceURI, String localname, String qName, Attributes attrs) {
        String flagID = PSMLUtil.getAttributeValue(attrs, "id");
        if (flagID == null) {
            Logger.error(MessageIDs.SCN6002W, new Object[]{this.getSceneContext().getCurrentPath()});
        } else {
            this._flagID = flagID;
        }
        String scope = PSMLUtil.getAttributeValue(attrs, "scope");
        if ("scene".equals(scope)) {
            this._scope = FlagScope.SCENE;
        } else if ("session".equals(scope)) {
            this._scope = FlagScope.SESSION;
        } else if ("system".equals(scope)) {
            this._scope = FlagScope.SYSTEM;
        } else {
            Logger.error(MessageIDs.SCN6003W, new Object[]{scope == null ? "null" : scope, this.getSceneContext().getCurrentPath()});
            this._flagID = null;
        }
        String action = PSMLUtil.getAttributeValue(attrs, "action");
        if (action != null) {
            if ("undeclare".equals(action)) {
                this._declare = false;
            } else if ("declare".equals(action)) {
                this._declare = true;
            } else {
                Logger.warn(MessageIDs.SCN6004W, new Object[]{this.getSceneContext().getCurrentPath()});
                this._flagID = null;
            }
        } else {
            this._declare = true;
        }
    }
}

