/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.text;

import java.awt.Dimension;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.text.Line;
import tsukuba_bunko.peko.canvas.text.Page;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.Coordinator;
import tsukuba_bunko.peko.scenario.SceneContext;
import tsukuba_bunko.peko.scenario.text.MessageIDs;
import tsukuba_bunko.peko.scenario.text.PageConfigurator;

public class TextCoordinator
extends Coordinator {
    protected boolean _pageConfigured = false;
    protected float _lineSpan = 0.0f;
    protected Line _lastLine = null;
    protected Dimension _sizeCache = new Dimension();

    public void prepare(SceneContext context, Thread activeThread) {
        super.prepare(context, activeThread);
        this._pageConfigured = false;
        this._lastLine = null;
    }

    public void begin() {
        if (this.isActiveThread()) {
            this._lastLine = null;
            this.getActionControler().setSaveEnabled(true);
        }
    }

    public void commit() {
        if (this.isActiveThread()) {
            this.getActionControler().setSaveEnabled(false);
            this.getCurrentPage().commit();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushText(String text) {
        int length;
        if (!this.isActiveThread()) {
            return;
        }
        Page page = this.getCurrentPage();
        if (!this._pageConfigured) {
            PageConfigurator.configure(page, this.getSceneContext());
            this._pageConfigured = true;
            this._lineSpan = this.getLineSpan();
        }
        if ((length = text.length()) == 0) {
            Logger.debug("[scnario.text] empty string is pecified.");
            return;
        }
        if (this._lastLine != null) {
            text = String.valueOf(this._lastLine.getText()) + text;
            length = text.length();
        }
        Logger.debug(text);
        AttributedString astring = new AttributedString(text);
        astring.addAttribute(TextAttribute.FONT, page.getDefaultFont());
        astring.addAttribute(TextAttribute.FOREGROUND, page.getForeground());
        LineBreakMeasurer lbm = new LineBreakMeasurer(astring.getIterator(), page.getFontRenderContext());
        float maxWidth = page.getMaxLineWidth();
        float lineSpan = this._lineSpan;
        TextLayout layout = null;
        Line line = null;
        layout = lbm.nextLayout(maxWidth);
        line = new Line();
        line.setTextLayout(layout);
        line.setText(text.substring(0, lbm.getPosition()));
        line.setForeground(page.getForeground());
        line.setShadowColor(page.getShadow());
        if (this._lastLine == null) {
            if (!this.isActiveThread()) return;
            line.setLineSpan(lineSpan);
            if (!page.isAdaptive(line)) {
                page = this.advancesNewPage();
            }
            page.addLine(line);
        } else {
            line.setLineSpan(lineSpan);
            if (!this.isActiveThread()) return;
            page.setLine(page.getLineCount() - 1, line);
        }
        this._lastLine = line;
        int lastLinePosition = 0;
        while (lbm.getPosition() < length) {
            lastLinePosition = lbm.getPosition();
            line = new Line();
            line.setTextLayout(lbm.nextLayout(maxWidth));
            line.setLineSpan(lineSpan);
            line.setText(text.substring(lastLinePosition, lbm.getPosition()));
            line.setForeground(page.getForeground());
            line.setShadowColor(page.getShadow());
            if (!this.isActiveThread()) return;
            if (!page.isAdaptive(line)) {
                page.updateContents();
                this.stop();
                page = this.advancesNewPage();
            }
            if (page == null) {
                return;
            }
            page.addLine(line);
            this._lastLine = line;
        }
        if (!this.isActiveThread()) return;
        page.updateContents();
    }

    public Page getCurrentPage() {
        return this.getCanvasManager().getCurrentPage();
    }

    public Page advancesNewPage() {
        if (this.isActiveThread()) {
            return this.getCanvasManager().advancesNewPage();
        }
        return null;
    }

    protected void stop() {
        if (this.isActiveThread()) {
            this.getActionControler().stop();
        }
    }

    protected float getLineSpan() {
        ResourceManager resources;
        Float lineSpan;
        SceneContext context = this.getSceneContext();
        String value = context.getProperty("canvas.text.line-span");
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (Exception e) {
                Logger.warn(MessageIDs.SCN2002W, (Throwable)e);
            }
        }
        if ((lineSpan = (Float)(resources = ResourceManager.getInstance()).getResource("peko.canvas.text.line-span")) != null) {
            return lineSpan.floatValue();
        }
        Logger.warn(MessageIDs.SCN2001W, new Object[]{"20.0"});
        return 20.0f;
    }
}

