/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.text.Page;
import tsukuba_bunko.peko.resource.ColorManager;
import tsukuba_bunko.peko.resource.DimensionDeserializer;
import tsukuba_bunko.peko.resource.FontManager;
import tsukuba_bunko.peko.resource.InsetsDeserializer;
import tsukuba_bunko.peko.resource.PointDeserializer;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.SceneContext;
import tsukuba_bunko.peko.scenario.text.MessageIDs;

public class PageConfigurator {
    protected PageConfigurator() {
    }

    public static void configure(Page page, SceneContext context) {
        Color c;
        ResourceManager resources = ResourceManager.getInstance();
        FontManager fonts = FontManager.getInstance();
        ColorManager colors = ColorManager.getInstance();
        boolean set = false;
        String value = context.getProperty("canvas.text.background.transparency");
        if (value != null) {
            try {
                page.setTransparency(Float.parseFloat(value));
                set = true;
            }
            catch (Exception e) {
                Logger.warn(MessageIDs.SCN2006W);
            }
        }
        if (!set) {
            Float trans = (Float)resources.getResource("peko.canvas.text.background.transparency");
            if (trans == null) {
                Logger.warn(MessageIDs.SCN2005W, new Object[]{"0.5"});
                page.setTransparency(0.5f);
            } else {
                page.setTransparency(trans.floatValue());
            }
        }
        set = false;
        value = context.getProperty("canvas.text.background.color");
        if (value == null) {
            Color c2 = (Color)resources.getResource("peko.canvas.text.background.color");
            if (c2 == null) {
                Logger.warn(MessageIDs.SCN2003W, new Object[]{"black"});
                c2 = Color.black;
            }
            page.setBackground(c2);
        } else {
            page.setBackground(colors.getColor(value));
        }
        String type = context.getProperty("canvas.text.view-type");
        if (type != null && !"window".equals(type) && !"full".equals(type)) {
            Logger.warn(MessageIDs.SCN2014W);
            type = null;
        }
        if (type == null && ((type = (String)resources.getResource("peko.canvas.text.view-type")) == null || !"window".equals(type) && !"full".equals(type))) {
            Logger.warn(MessageIDs.SCN2013W, new Object[]{"full"});
            type = "full";
        }
        Dimension viewSize = null;
        if (type.equals("window")) {
            value = context.getProperty("canvas.text.size");
            if (value != null) {
                try {
                    viewSize = DimensionDeserializer.parseDimension(value);
                }
                catch (Exception e) {
                    Logger.warn(MessageIDs.SCN2016W);
                }
            }
            if (viewSize == null && (viewSize = (Dimension)resources.getResource("peko.canvas.text.size")) == null) {
                Logger.warn(MessageIDs.SCN2015W, new Object[]{"600, 180"});
                viewSize = new Dimension(600, 180);
            }
            Point location = null;
            value = context.getProperty("canvas.text.location");
            if (value != null) {
                try {
                    location = PointDeserializer.parsePoint(value);
                }
                catch (Exception e) {
                    Logger.warn(MessageIDs.SCN2018W, (Throwable)e);
                }
            }
            if (location == null && (location = (Point)resources.getResource("peko.canvas.text.location")) == null) {
                Logger.warn(MessageIDs.SCN2017W, new Object[]{"0, 0"});
                location = new Point(0, 0);
            }
            page.setLocation(location.x, location.y);
        } else {
            page.setLocation(0, 0);
            viewSize = page.getTextCanvas().getSize();
        }
        page.setSize(viewSize);
        Insets padding = null;
        value = context.getProperty("canvas.text.padding");
        if (value != null) {
            try {
                padding = InsetsDeserializer.parseInsets(value);
            }
            catch (Exception e) {
                Logger.warn(MessageIDs.SCN2020W);
            }
        }
        if (padding == null && (padding = (Insets)resources.getResource("peko.canvas.text.padding")) == null) {
            Logger.warn(MessageIDs.SCN2019W, new Object[]{"10,40,10,10"});
            padding = new Insets(10, 40, 10, 10);
        }
        page.setPadding(padding.top, padding.left, padding.bottom, padding.right);
        HashMap<TextAttribute, Object> fontAttrs = new HashMap<TextAttribute, Object>(17);
        Font baseFont = (Font)resources.getResource("peko.canvas.text.font");
        if (baseFont == null) {
            Logger.warn(MessageIDs.SCN2011W, new Object[]{"Serif, 20"});
            fontAttrs = new HashMap(17);
            fontAttrs.put(TextAttribute.FAMILY, "Serif");
            fontAttrs.put(TextAttribute.SIZE, new Float(20.0f));
            fontAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        } else {
            fontAttrs.putAll(baseFont.getAttributes());
        }
        value = context.getProperty("canvas.text.font.family");
        if (value != null) {
            fontAttrs.put(TextAttribute.FAMILY, value);
        }
        if ((value = context.getProperty("canvas.text.font.size")) != null) {
            try {
                fontAttrs.put(TextAttribute.SIZE, Float.valueOf(value));
            }
            catch (Exception e) {
                Logger.warn(MessageIDs.SCN2012W, new Object[]{"size"});
            }
        }
        if ((value = context.getProperty("canvas.text.font.style")) != null) {
            if ("italic".equals(value)) {
                fontAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else if ("normal".equals(value)) {
                fontAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            } else {
                Logger.warn(MessageIDs.SCN2012W, new Object[]{"style"});
            }
        }
        if ((value = context.getProperty("canvas.text.font.weight")) != null) {
            if ("bold".equals(value)) {
                fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else if ("normal".equals(value)) {
                fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            }
        }
        page.setDefaultFont(fonts.getFont(fontAttrs));
        value = context.getProperty("canvas.text.foreground.color");
        if (value == null) {
            c = (Color)resources.getResource("peko.canvas.text.foreground.color");
            if (c == null) {
                Logger.warn(MessageIDs.SCN2007W, new Object[]{"white"});
                c = Color.white;
            }
            page.setForeground(c);
        } else {
            page.setForeground(colors.getColor(value));
        }
        value = context.getProperty("canvas.text.foreground.shadow");
        if (value == null) {
            c = (Color)resources.getResource("peko.canvas.text.foreground.shadow");
            if (c == null) {
                Logger.warn(MessageIDs.SCN2007W, new Object[]{"black"});
                c = Color.black;
            }
            page.setShadow(c);
        } else {
            page.setShadow(colors.getColor(value));
        }
        page.updateCanvas();
    }
}

