/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.stage;

import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.canvas.stage.Actor;
import tsukuba_bunko.peko.canvas.stage.Stage;
import tsukuba_bunko.peko.scenario.Coordinator;
import tsukuba_bunko.peko.scenario.SceneContext;

public class StageCoordinator
extends Coordinator {
    public static final int POSITION_CENTER = 0;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    protected int _level = 0;

    public Actor getActor(String name) {
        Actor actor = this.getStage().getActor(name);
        if (actor == null) {
            return null;
        }
        Actor copy = new Actor(actor.getName());
        actor.copyTo(copy);
        return copy;
    }

    public void enter(Actor actor) {
        if (this.isActiveThread()) {
            this.getStage().enter(actor);
        }
    }

    public void action(Actor actor) {
        Stage stage;
        Actor current;
        if (this.isActiveThread() && (current = (stage = this.getStage()).getActor(actor.getName())) != null) {
            if (current.getLooksImage() != actor.getLooksImage()) {
                stage.exit(actor.getName());
                stage.enter(actor);
            } else {
                stage.enter(actor);
            }
        }
    }

    public Actor exit(String name) {
        if (this.isActiveThread()) {
            return this.getStage().exit(name);
        }
        return null;
    }

    public void setBackgroundColor(String color) {
        if (this.isActiveThread()) {
            this.getStage().setBackgroundColor(color);
        }
    }

    public void setBackgroundImage(String image) {
        if (this.isActiveThread()) {
            this.getStage().setBackgroundImage(image);
        }
    }

    public void showSlide(String slide) {
        if (this.isActiveThread()) {
            this.getStage().showSlide(slide);
        }
    }

    public void hideSlide() {
        if (this.isActiveThread()) {
            this.getStage().hideSlide();
        }
    }

    public void playBGM(String id, String clipName, boolean loop) {
        if (this.isActiveThread()) {
            this.getStage().playBGM(id, clipName, loop);
        }
    }

    public void stopBGM(String id) {
        if (this.isActiveThread()) {
            this.getStage().stopBGM(id);
        }
    }

    public void playSE(String id, String clipName, boolean loop) {
        if (this.isActiveThread()) {
            this.getStage().playSE(id, clipName, loop);
        }
    }

    public void stopSE(String id) {
        if (this.isActiveThread()) {
            this.getStage().stopSE(id);
        }
    }

    public void updateStage(String effect) {
        if (this._level > 1) {
            return;
        }
        Stage stage = this.getStage();
        stage.updateCanvas(effect);
    }

    public void updateStage() {
        if (this.isActiveThread()) {
            this.updateStage(null);
        }
    }

    public void hideTextCanvas() {
        if (this.isActiveThread()) {
            this.getCanvasManager().hideTextCanvas();
        }
    }

    protected Stage getStage() {
        return this.getCanvasManager().getStage();
    }

    public void prepare(SceneContext context, Thread activeThread) {
        super.prepare(context, activeThread);
        this._level = 0;
    }

    public void begin() {
        if (this.isActiveThread()) {
            ++this._level;
            this.getCanvasManager().hideTextCanvas();
            this.getActionControler().setActive(false);
            this.getActionControler().setSaveEnabled(true);
        }
    }

    public void commit() {
        if (this.isActiveThread()) {
            --this._level;
            if (this._level == 0) {
                ActionControler controler = this.getActionControler();
                controler.setActive(true);
                controler.setSaveEnabled(false);
                Stage stage = this.getStage();
                stage.commit();
            }
        }
    }
}

