/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.select;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.ElementHandler;
import tsukuba_bunko.peko.scenario.FlagScope;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.select.MessageIDs;
import tsukuba_bunko.peko.scenario.select.SelectCoordinator;

public class SelectHandler
extends ElementHandler {
    private Map _attributes = new HashMap(89);
    private String _id = null;
    private StringBuffer _text = null;
    private String _name = null;
    private FlagScope _scope = null;

    protected SelectCoordinator getSelectCoordinator() {
        return this.getSceneContext().getSceneProcessor().getSelectCoordinator();
    }

    public void startDocument() {
        this._attributes.clear();
        this.setEndOfScene(false);
    }

    public void endDocument() {
        SelectCoordinator coordinator = this.getSelectCoordinator();
        String id = coordinator.select();
        if (id == null) {
            return;
        }
        this.getSceneContext().declareFlag(String.valueOf(this._name) + ":" + id, this._scope);
        coordinator.end();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (localName.equals("item")) {
            if (this._id != null) {
                Logger.error("[scenario.select] BUG! Invalid PSML Structure. location: " + this.getSceneContext().getCurrentPath());
                throw new SAXException("Invalid PSML Structure.");
            }
            String id = PSMLUtil.getAttributeValue(attrs, "id");
            if (id == null || id.length() == 0) {
                Logger.warn(MessageIDs.SCN4002W, new Object[]{this.getSceneContext().getCurrentPath()});
                this._id = null;
            } else {
                this._id = id;
                this._text = new StringBuffer();
            }
        } else if ("select".equals(localName)) {
            String name = PSMLUtil.getAttributeValue(attrs, "name");
            if (name == null || name.length() == 0) {
                Logger.error(MessageIDs.SCN4001E, new Object[]{this.getSceneContext().getCurrentPath()});
                throw new SAXException("invalid select element appeared.");
            }
            this._name = PSMLUtil.getAttributeValue(attrs, "name");
            String flagScope = PSMLUtil.getAttributeValue(attrs, "scope");
            this._scope = flagScope == null || flagScope.equals("session") ? FlagScope.SESSION : (flagScope.equals("scene") ? FlagScope.SCENE : (flagScope.equals("system") ? FlagScope.SYSTEM : FlagScope.SESSION));
            this.getSelectCoordinator().begin();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (this._id != null && localName.equals("item")) {
            if (this._text.length() == 0) {
                Logger.warn(MessageIDs.SCN4003W, new Object[]{this.getSceneContext().getCurrentPath()});
            } else {
                SelectCoordinator coordinator = this.getSceneContext().getSceneProcessor().getSelectCoordinator();
                coordinator.addSelectItem(this._id, new String(this._text));
            }
            this._id = null;
            this._text = null;
        }
    }

    public void characters(char[] ch, int begin, int length) {
        if (this._text != null) {
            this._text.append(ch, begin, length);
        }
    }
}

