/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.select;

import java.util.ArrayList;
import java.util.List;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.CanvasManager;
import tsukuba_bunko.peko.canvas.select.SelectItem;
import tsukuba_bunko.peko.scenario.Coordinator;

public class SelectCoordinator
extends Coordinator {
    protected List _selectItems = null;
    protected Thread _activeThread = null;

    public void begin() {
        if (this.isActiveThread()) {
            this.getActionControler().setSaveEnabled(true);
            this._selectItems = new ArrayList(4);
        }
    }

    public void commit() {
        if (this.isActiveThread()) {
            this.getActionControler().setSaveEnabled(false);
        }
    }

    public void addSelectItem(String id, String text) {
        if (id == null) {
            throw new IllegalArgumentException("id is not specified.");
        }
        if (text == null) {
            throw new IllegalArgumentException("text is not specified.");
        }
        if (this.isActiveThread()) {
            SelectItem item = new SelectItem();
            item.setID(id);
            item.setText(text);
            this._selectItems.add(item);
        }
    }

    public String select() {
        if (this.isActiveThread()) {
            if (this._selectItems == null || this._selectItems.isEmpty()) {
                Logger.debug("[scenario.select] no select items!");
                return null;
            }
            CanvasManager canvasManager = this.getCanvasManager();
            String id = canvasManager.showSelect(this._selectItems);
            if (id == null) {
                Logger.debug("[scenario.select] canceled.");
            }
            canvasManager.advancesNewPage();
            return id;
        }
        return null;
    }

    public void end() {
        if (this.isActiveThread()) {
            this._activeThread = null;
            if (this._selectItems != null) {
                this._selectItems.clear();
                this._selectItems = null;
            }
        }
    }
}

