/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.ElementHandler;
import tsukuba_bunko.peko.scenario.HandlerRegistry;
import tsukuba_bunko.peko.scenario.MessageIDs;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.ScenarioProcessor;
import tsukuba_bunko.peko.scenario.SceneContext;
import tsukuba_bunko.peko.scenario.select.SelectCoordinator;
import tsukuba_bunko.peko.scenario.stage.StageCoordinator;
import tsukuba_bunko.peko.scenario.text.TextCoordinator;
import tsukuba_bunko.peko.session.Session;

public class SceneProcessor
extends DefaultHandler
implements Runnable {
    public static final String PSML_PUBLICID = "-//Tsukuba Bunko//DTD PSML Scene 1.0//EN";
    public static final String PSML_SYSTEMID = "http://softlab.tsukuba-bunko.org/dtd/psml10-scene.dtd";
    protected SAXParser _parser = null;
    protected boolean _running = false;
    protected boolean _aborted = false;
    protected URL _sceneURL = null;
    protected SceneContext _sceneContext = null;
    protected ScenarioProcessor _owner = null;
    protected int _level = -1;
    protected int _processStartedLevel = -1;
    protected int _ignoreStartedLevel = -1;
    protected HandlerRegistry _registry = null;
    protected ElementHandler _handler = null;
    protected SceneContext.Node _startNode = null;
    protected TextCoordinator _textCoordinator = null;
    protected StageCoordinator _stageCoordinator = null;
    protected SelectCoordinator _selectCoordinator = null;

    public SceneProcessor(ScenarioProcessor owner) {
        this._owner = owner;
        this._registry = HandlerRegistry.newInstance();
        this.getSAXParser();
        Logger.debug("[scenario] create SceneProcessor.");
    }

    public SceneContext getSceneContext() {
        return this._sceneContext;
    }

    public HandlerRegistry getHandlerRegistry() {
        return this._registry;
    }

    public void setTextCoordinator(TextCoordinator coordinator) {
        this._textCoordinator = coordinator;
    }

    public TextCoordinator getTextCoordinator() {
        return this._textCoordinator;
    }

    public void setStageCoordinator(StageCoordinator coordinator) {
        this._stageCoordinator = coordinator;
    }

    public StageCoordinator getStageCoordinator() {
        return this._stageCoordinator;
    }

    public void setSelectCoordinator(SelectCoordinator coordinator) {
        this._selectCoordinator = coordinator;
    }

    public SelectCoordinator getSelectCoordinator() {
        return this._selectCoordinator;
    }

    public void process(String sceneName, Session session) {
        if (this._running) {
            IllegalStateException ise = new IllegalStateException("scene processor is still running.");
            Logger.fatal(MessageIDs.SCN0007F);
            PekoSystem.showErrorDialog(MessageIDs.SCN0007F.getMessage(), ise.fillInStackTrace(), true);
        }
        this._sceneURL = this.getSceneURL(sceneName);
        this._sceneContext = new SceneContext(sceneName, session, this);
        this._startNode = this._sceneContext.getLastCommittedNode();
        if (this._startNode != null) {
            Logger.debug("[scenario.scene] start from: " + this._startNode.getPath());
        }
        Thread thread = new Thread(this);
        session.setSceneContext(this._sceneContext, thread);
        this._textCoordinator.prepare(this._sceneContext, thread);
        this._stageCoordinator.prepare(this._sceneContext, thread);
        this._selectCoordinator.prepare(this._sceneContext, thread);
        this._aborted = false;
        thread.start();
    }

    public void abort() {
        this._aborted = true;
        this._textCoordinator.dormantize();
        this._stageCoordinator.dormantize();
        this._selectCoordinator.dormantize();
        Logger.debug("[scenario] release stopped thread.");
        ActionControler controler = PekoSystem.getInstance().getActionControler();
        controler.start();
    }

    public boolean isAborted() {
        return this._aborted;
    }

    protected SAXParser getSAXParser() {
        if (this._parser == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                if ("on".equals(System.getProperty("debug", "off"))) {
                    Logger.debug("[scenario.scene] set PSML validating on.");
                    factory.setValidating(true);
                } else {
                    Logger.debug("[scenario.scene] set PSML validating off.");
                    factory.setValidating(false);
                }
                this._parser = factory.newSAXParser();
            }
            catch (SAXException se) {
                Logger.fatal(MessageIDs.SCN0000F);
                PekoSystem.showErrorDialog(MessageIDs.SCN0000F.getMessage(), se, true);
            }
            catch (ParserConfigurationException pce) {
                Logger.fatal(MessageIDs.SCN0000F);
                PekoSystem.showErrorDialog(MessageIDs.SCN0000F.getMessage(), pce, true);
            }
        }
        return this._parser;
    }

    protected URL getSceneURL(String scene) {
        ResourceManager resources = ResourceManager.getInstance();
        URL sceneDir = resources.getLocationResources().getScenesDirecotryURL();
        try {
            return new URL(sceneDir, scene);
        }
        catch (Exception e) {
            Logger.fatal(MessageIDs.SCN0006F, (Throwable)e);
            PekoSystem.showErrorDialog(MessageIDs.SCN0006F.getMessage(), e, true);
            return null;
        }
    }

    public void run() {
        this._running = true;
        try {
            Logger.debug(this._sceneURL.toString());
            SAXParser parser = this.getSAXParser();
            parser.parse(this._sceneURL.toString(), (DefaultHandler)this);
        }
        catch (Exception e) {
            Logger.fatal(MessageIDs.SCN0005F, new Object[]{this._sceneContext.getCurrentPath()}, e);
            PekoSystem.showErrorDialog(MessageIDs.SCN0005F.getMessage(new Object[]{this._sceneContext.getCurrentPath()}), e, true);
        }
        this._running = false;
        this._owner.pushSceneProcessor(this);
    }

    public void startDocument() throws SAXException {
        if (this._aborted) {
            return;
        }
        this._level = 0;
        this._processStartedLevel = -1;
        this._ignoreStartedLevel = -1;
        this._handler = null;
    }

    public void endDocument() throws SAXException {
        if (this._aborted) {
            return;
        }
        this._owner.sceneEnded(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (this._aborted) {
            return;
        }
        ++this._level;
        this._sceneContext.pushNode(qName);
        if (this._startNode != null) {
            if (!this._sceneContext.isCurrentNode(this._startNode)) return;
            this._startNode = null;
        } else {
            if (this._ignoreStartedLevel != -1) {
                return;
            }
            if (!PSMLUtil.isEvaluatable(attrs, this._sceneContext)) {
                this._ignoreStartedLevel = this._level;
                return;
            }
        }
        if (this._handler == null) {
            this._handler = this._registry.getElementHandler(namespaceURI, localName);
            if (this._handler == null) {
                return;
            }
            this._sceneContext.saveCurrentNode();
            this._handler.setSceneContext(this._sceneContext);
            this._processStartedLevel = this._level;
            this._handler.startDocument();
        }
        try {
            this._handler.startElement(namespaceURI, localName, qName, attrs);
            return;
        }
        catch (Exception e) {
            Logger.fatal(MessageIDs.SCN0005F, new Object[]{this._sceneContext.getCurrentPath()}, e);
            PekoSystem.showErrorDialog(MessageIDs.SCN0005F.getMessage(new Object[]{this._sceneContext.getCurrentPath()}), e, true);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this._aborted) {
            return;
        }
        if (this._startNode == null) {
            if (this._level == this._ignoreStartedLevel) {
                this._ignoreStartedLevel = -1;
            } else if (this._ignoreStartedLevel == -1 && this._handler != null) {
                try {
                    this._handler.endElement(namespaceURI, localName, qName);
                    if (this._level == this._processStartedLevel) {
                        this._handler.endDocument();
                        if (this._handler.isEndOfScene()) {
                            this._owner.sceneEnded(this);
                            this._aborted = true;
                        }
                        this._handler = null;
                        this._processStartedLevel = -1;
                    }
                }
                catch (Exception e) {
                    Logger.fatal(MessageIDs.SCN0005F, new Object[]{this._sceneContext.getCurrentPath()}, e);
                    PekoSystem.showErrorDialog(MessageIDs.SCN0005F.getMessage(new Object[]{this._sceneContext.getCurrentPath()}), e, true);
                }
            }
        }
        --this._level;
        this._sceneContext.popNode();
    }

    public void characters(char[] ch, int begin, int length) throws SAXException {
        if (this._aborted) {
            return;
        }
        if (this._ignoreStartedLevel != -1 || this._handler == null) {
            return;
        }
        if (this._handler != null) {
            this._handler.characters(ch, begin, length);
        }
    }

    public void processingInstruction(String target, String data) {
    }

    public void warning(SAXParseException exception) {
        Logger.warn(MessageIDs.SCN0002W, new Object[]{exception.getMessage()}, exception);
    }

    public void error(SAXParseException exception) {
        Logger.error(MessageIDs.SCN0003E, new Object[]{exception.getMessage()}, exception);
    }

    public void fatalError(SAXParseException exception) {
        Logger.fatal(MessageIDs.SCN0004F, new Object[]{exception.getMessage()}, exception);
        PekoSystem.showErrorDialog("fail to parsing scene data.", exception, true);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        boolean isPSMLScene = false;
        if (publicId != null) {
            if (PSML_PUBLICID.equals(publicId)) {
                isPSMLScene = true;
            }
        } else if (systemId != null && PSML_SYSTEMID.equals(systemId)) {
            isPSMLScene = true;
        }
        if (isPSMLScene) {
            InputStream is = null;
            try {
                is = this.getClass().getClassLoader().getResourceAsStream("psml10-scene.dtd");
            }
            catch (Exception e) {
                Logger.warn(MessageIDs.SCN0001W, (Throwable)e);
                return null;
            }
            if (is != null) {
                return new InputSource(is);
            }
            Logger.warn(MessageIDs.SCN0001W);
            return null;
        }
        return null;
    }
}

