/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.FlagScope;
import tsukuba_bunko.peko.scenario.NextSceneMapping;
import tsukuba_bunko.peko.scenario.SceneProcessor;
import tsukuba_bunko.peko.session.Session;

public class SceneContext
implements Serializable {
    protected String _sceneName = null;
    protected String _sceneTitle = null;
    protected Map _properties = null;
    protected NextSceneMapping _nextSceneMapping = null;
    protected transient Node _current = null;
    protected Node _lastCommittedNode = null;
    protected Set _sceneScopeFlags = null;
    protected transient Session _session = null;
    protected transient SceneProcessor _processor = null;

    public SceneContext(String sceneName, Session session, SceneProcessor processor) {
        this._sceneName = sceneName;
        this._session = session;
        this._processor = processor;
        SceneContext previous = session.getSceneContext();
        if (previous != null) {
            this._lastCommittedNode = previous.getLastCommittedNode();
            this._properties = previous._properties;
            this._nextSceneMapping = previous.getNextSceneMapping();
            this._sceneScopeFlags = previous._sceneScopeFlags;
        } else {
            this._nextSceneMapping = new NextSceneMapping();
            this._sceneScopeFlags = new HashSet();
        }
    }

    public String getSceneName() {
        return this._sceneName;
    }

    public void setSceneTitle(String title) {
        this._sceneTitle = title;
    }

    public String getSceneTitle() {
        return this._sceneTitle;
    }

    public Session getSession() {
        return this._session;
    }

    public SceneProcessor getSceneProcessor() {
        return this._processor;
    }

    public void setProperty(String name, String value) {
        if (this._properties == null) {
            this._properties = new HashMap(17);
        }
        this._properties.put(name, value);
    }

    public String getProperty(String name) {
        if (this._properties == null) {
            return null;
        }
        return (String)this._properties.get(name);
    }

    public void setNextSceneMapping(NextSceneMapping mapping) {
        this._nextSceneMapping = mapping;
    }

    public NextSceneMapping getNextSceneMapping() {
        return this._nextSceneMapping;
    }

    public String getNextSceneName() {
        return this._nextSceneMapping.getNextScene(this);
    }

    public void pushNode(String nodeName) {
        if (this._current == null) {
            this._current = new Node(null, nodeName.intern(), 1);
        } else {
            int position = this._current.countSibling(nodeName) + 1;
            Node child = new Node(this._current, nodeName.intern(), position);
            this._current.addChildNode(child);
            this._current = child;
        }
    }

    public void popNode() {
        if (this._current == null) {
            Logger.error("[scenario] BUG! invalid state of SceneLog.");
        } else {
            this._current.removeChildren();
            this._current = this._current.getParentNode();
        }
    }

    public void saveCurrentNode() {
        this._lastCommittedNode = this._current;
    }

    public Node getLastCommittedNode() {
        return this._lastCommittedNode;
    }

    public boolean isCurrentNode(Node node) {
        if (node == this._current) {
            return true;
        }
        if (this._current != null) {
            return this._current.equals(node);
        }
        return false;
    }

    public Node getCurrentNode() {
        Node copy;
        Node node = this._current;
        if (node == null) {
            return null;
        }
        Node temp = copy = new Node(null, node._nodeName, node._position);
        while ((node = node.getParentNode()) != null) {
            temp._parent = new Node(null, node.getNodeName(), node.getPosition());
            temp = temp.getParentNode();
        }
        return copy;
    }

    public String getCurrentPath() {
        if (this._current != null) {
            return this._current.getPath();
        }
        return "/";
    }

    public void declareFlag(String flagID, FlagScope scope) {
        if (flagID == null) {
            throw new IllegalArgumentException();
        }
        if (scope == FlagScope.SCENE) {
            this._sceneScopeFlags.add(flagID);
        } else if (scope == FlagScope.SESSION) {
            this._session.declareSessionFlag(flagID);
        } else if (scope == FlagScope.SYSTEM) {
            this._session.declareSystemFlag(flagID);
        }
    }

    public void undeclareFlag(String flagID, FlagScope scope) {
        if (flagID == null) {
            throw new IllegalArgumentException();
        }
        if (scope == FlagScope.SCENE) {
            this._sceneScopeFlags.remove(flagID);
        } else if (scope == FlagScope.SESSION) {
            this._session.undeclareSessionFlag(flagID);
        } else if (scope == FlagScope.SYSTEM) {
            this._session.undeclareSystemFlag(flagID);
        }
    }

    public boolean isDeclaredFlag(String flagID) {
        if (this._sceneScopeFlags.contains(flagID)) {
            return true;
        }
        if (this._session.isDeclaredSessionFlag(flagID)) {
            return true;
        }
        return this._session.isDeclaredSystemFlag(flagID);
    }

    public boolean isDeclaredFlag(String flagID, FlagScope scope) {
        if (scope == FlagScope.SCENE) {
            return this._sceneScopeFlags.contains(flagID);
        }
        if (scope == FlagScope.SESSION) {
            return this._session.isDeclaredSessionFlag(flagID);
        }
        if (scope == FlagScope.SYSTEM) {
            return this._session.isDeclaredSystemFlag(flagID);
        }
        return false;
    }

    public static class Node
    implements Serializable {
        protected Node _parent = null;
        protected String _nodeName = null;
        protected int _position = 0;
        protected List _children = null;

        public Node(Node parent, String nodeName, int position) {
            this._parent = parent;
            this._nodeName = nodeName.intern();
            this._position = position;
        }

        public Node getParentNode() {
            return this._parent;
        }

        public String getNodeName() {
            return this._nodeName;
        }

        public int getPosition() {
            return this._position;
        }

        public void addChildNode(Node child) {
            if (this._children == null) {
                this._children = new ArrayList();
            }
            this._children.add(child);
        }

        public int countSibling(String nodeName) {
            if (this._children == null) {
                return 0;
            }
            String symbol = nodeName.intern();
            List children = this._children;
            int size = children.size();
            Node node = null;
            int count = 0;
            int i = 0;
            while (i < size) {
                node = (Node)children.get(i);
                if (node._nodeName == symbol) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public void removeChildren() {
            if (this._children != null) {
                List children = this._children;
                int size = children.size();
                int i = 0;
                while (i < size) {
                    ((Node)children.get(i)).removeChildren();
                    ++i;
                }
                children.clear();
                this._children = null;
            }
        }

        public String getPath() {
            StringBuffer sink = new StringBuffer();
            Node node = this;
            while (node != null) {
                sink.insert(0, node);
                node = node.getParentNode();
            }
            return new String(sink);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node target = (Node)obj;
                Node node = this;
                while (node != null && target != null) {
                    if (!node._nodeName.equals(target._nodeName) || node._position != target._position) {
                        return false;
                    }
                    node = node._parent;
                    target = target._parent;
                }
                return node == null && target == null;
            }
            return false;
        }

        public String toString() {
            return "/" + this._nodeName + "[" + this._position + "]";
        }
    }
}

