/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.util.ArrayList;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.scenario.MessageIDs;
import tsukuba_bunko.peko.scenario.SceneContext;
import tsukuba_bunko.peko.scenario.SceneProcessor;
import tsukuba_bunko.peko.scenario.select.SelectCoordinator;
import tsukuba_bunko.peko.scenario.stage.StageCoordinator;
import tsukuba_bunko.peko.scenario.text.TextCoordinator;
import tsukuba_bunko.peko.session.Session;

public class ScenarioProcessor {
    protected ArrayList _queue = new ArrayList(5);
    protected int _maxQueueSize = 4;
    protected int _processorCount = 0;
    protected SceneProcessor _currentSceneProcessor = null;
    protected Session _session = null;
    protected TextCoordinator _textCooridnator = null;
    protected StageCoordinator _stageCoordinator = null;
    protected SelectCoordinator _selectCoordinator = null;

    public ScenarioProcessor() {
        this._queue.add(new SceneProcessor(this));
        this._queue.add(new SceneProcessor(this));
        this._textCooridnator = new TextCoordinator();
        this._stageCoordinator = new StageCoordinator();
        this._selectCoordinator = new SelectCoordinator();
    }

    public synchronized void playScenario(String sceneName, Session session) {
        if (this._currentSceneProcessor != null) {
            Logger.error("[scene] BUG! current scene processor is still alive!");
            this.exit();
        }
        SceneProcessor processor = this.getSceneProcessor();
        processor.setTextCoordinator(this._textCooridnator);
        processor.setStageCoordinator(this._stageCoordinator);
        processor.setSelectCoordinator(this._selectCoordinator);
        this._currentSceneProcessor = processor;
        this._session = session;
        ActionControler controler = PekoSystem.getInstance().getActionControler();
        controler.setActive(true);
        processor.process(sceneName, session);
    }

    public synchronized void exit() {
        if (this._currentSceneProcessor != null) {
            Logger.debug("[scenario] exit ScenarioProcessor");
            this._currentSceneProcessor.abort();
            this._currentSceneProcessor = null;
            this._session = null;
            ActionControler controler = PekoSystem.getInstance().getActionControler();
            controler.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized SceneProcessor getSceneProcessor() {
        try {
            if (this._queue.isEmpty()) {
                if (this._processorCount < this._maxQueueSize) {
                    SceneProcessor processor = new SceneProcessor(this);
                    ++this._processorCount;
                    return processor;
                }
                while (this._queue.isEmpty()) {
                    this.wait(50L);
                }
            }
            return (SceneProcessor)this._queue.remove(0);
        }
        catch (InterruptedException ie) {
            Logger.debug("[scene] interrupted", ie);
            return null;
        }
    }

    protected synchronized void pushSceneProcessor(SceneProcessor processor) {
        this._queue.add(processor);
    }

    protected synchronized void sceneEnded(SceneProcessor processor) {
        if (this._currentSceneProcessor == processor) {
            SceneContext context = processor.getSceneContext();
            String nextSceneName = context.getNextSceneName();
            if (nextSceneName != null) {
                if ("peko:end".equals(nextSceneName)) {
                    this.exit();
                    ActionControler controler = PekoSystem.getInstance().getActionControler();
                    controler.returnTitle(true);
                } else {
                    this._currentSceneProcessor.abort();
                    this._session.setSceneContext(null);
                    PekoSystem.getInstance().getCanvasManager().advancesNewPage();
                    PekoSystem.getInstance().getCanvasManager().getCurrentPage().commit();
                    this._currentSceneProcessor = this.getSceneProcessor();
                    this._currentSceneProcessor.setTextCoordinator(this._textCooridnator);
                    this._currentSceneProcessor.setStageCoordinator(this._stageCoordinator);
                    this._currentSceneProcessor.setSelectCoordinator(this._selectCoordinator);
                    this._currentSceneProcessor.process(context.getNextSceneName(), this._session);
                }
            } else {
                Logger.error(MessageIDs.SCN0012E);
                this.exit();
                ActionControler controler = PekoSystem.getInstance().getActionControler();
                controler.returnTitle(true);
            }
        }
    }
}

