/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.MessageIDs;
import tsukuba_bunko.peko.scenario.SceneContext;

public final class PSMLUtil {
    private PSMLUtil() {
    }

    public static String removeISOControlChar(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int beginIndex = -1;
        boolean isISOControlCharSequence = false;
        int length = string.length();
        StringBuffer buffer = null;
        int current = 0;
        while (current < length) {
            if (Character.isISOControl(string.charAt(current))) {
                if (!isISOControlCharSequence) {
                    if (buffer == null) {
                        buffer = current == 0 ? new StringBuffer() : new StringBuffer(string.substring(0, current));
                    } else {
                        buffer.append(string.substring(beginIndex, current));
                    }
                    isISOControlCharSequence = true;
                    beginIndex = -1;
                }
            } else if (isISOControlCharSequence) {
                beginIndex = current;
                isISOControlCharSequence = false;
            }
            ++current;
        }
        if (beginIndex != -1) {
            buffer.append(string.substring(beginIndex));
        }
        if (buffer != null) {
            return new String(buffer);
        }
        return string;
    }

    public static String getAttributeValue(Attributes attrs, String localName) {
        String value = attrs.getValue("http://tsukuba-bunko.org/ns/psml-scene", localName);
        if (value == null) {
            value = attrs.getValue(localName);
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        if ((value = PSMLUtil.removeISOControlChar(value).trim()).length() == 0) {
            Logger.warn(MessageIDs.SCN0011W, new Object[]{localName});
            return null;
        }
        return value;
    }

    public static final boolean isEvaluatable(Attributes attrs, SceneContext context) {
        return PSMLUtil.isEvaluatable(PSMLUtil.getAttributeValue(attrs, "test"), context);
    }

    public static final boolean isEvaluatable(String target, SceneContext context) {
        if (target == null || target.length() == 0) {
            return true;
        }
        if (context == null) {
            return false;
        }
        boolean result = false;
        boolean multiple = target.charAt(0) == '[';
        boolean inBracket = false;
        boolean individualResult = true;
        StringTokenizer st = new StringTokenizer(target, "[],", true);
        String token = null;
        String lastToken = null;
        int position = 0;
        while (st.hasMoreTokens()) {
            lastToken = token;
            token = st.nextToken();
            position += token.length();
            token = token.trim();
            if (!multiple) {
                if ("[".equals(token) || "]".equals(token)) {
                    Logger.warn(MessageIDs.SCN0008W, new Object[]{String.valueOf(position), token});
                    return false;
                }
                if (",".equals(token)) continue;
                if (token.charAt(0) == '!') {
                    if (token.length() == 1) {
                        Logger.warn(MessageIDs.SCN0008W, new Object[]{String.valueOf(position), token});
                        return false;
                    }
                    token = token.substring(1);
                    individualResult = individualResult && !context.isDeclaredFlag(token);
                    continue;
                }
                individualResult = individualResult && context.isDeclaredFlag(token);
                continue;
            }
            if (inBracket) {
                if ("]".equals(token)) {
                    if (lastToken != null && ",".equals(lastToken)) {
                        Logger.warn(MessageIDs.SCN0008W, new Object[]{String.valueOf(position), token});
                        return false;
                    }
                    result = result || individualResult;
                    individualResult = true;
                    inBracket = false;
                    continue;
                }
                if (",".equals(token)) continue;
                if (token.charAt(0) == '!') {
                    if (token.length() == 1) {
                        Logger.warn(MessageIDs.SCN0008W, new Object[]{String.valueOf(position), token});
                        return false;
                    }
                    token = token.substring(1);
                    individualResult = individualResult && !context.isDeclaredFlag(token);
                    continue;
                }
                individualResult = individualResult && context.isDeclaredFlag(token);
                continue;
            }
            if ("[".equals(token)) {
                inBracket = true;
                continue;
            }
            Logger.warn(MessageIDs.SCN0008W, new Object[]{String.valueOf(position), token});
            return false;
        }
        if (multiple) {
            if (!"]".equals(token)) {
                Logger.warn(MessageIDs.SCN0008W, new Object[]{String.valueOf(position), token});
                return false;
            }
        } else {
            if (",".equals(token)) {
                Logger.warn(MessageIDs.SCN0008W, new Object[]{String.valueOf(position), token});
                return false;
            }
            result = individualResult;
        }
        return result;
    }
}

