/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.MessageIDs;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.SceneContext;

public class NextSceneMapping
implements Serializable {
    private List _conditionList = new ArrayList();
    private Map _nextScenes = new HashMap();

    public void addNextSceneMapping(String condition, String nextScene) {
        if (this._conditionList.contains(condition)) {
            Logger.warn(MessageIDs.SCN0010W, new Object[]{condition, this._nextScenes.get(condition), nextScene});
        } else {
            this._conditionList.add(condition);
            this._nextScenes.put(condition, nextScene);
        }
    }

    public void setDefaultSceneMapping(String nextScene) {
        this.setDefaultSceneMapping(nextScene, true);
    }

    public void setDefaultSceneMapping(String nextScene, boolean warn) {
        if (this._nextScenes.containsKey(null) && warn) {
            Logger.warn(MessageIDs.SCN0010W, new Object[]{"_default_", this._nextScenes.get(null), nextScene});
        } else {
            this._nextScenes.put(null, nextScene);
        }
    }

    public String getNextScene(SceneContext context) {
        Iterator itr = this._conditionList.iterator();
        String condition = null;
        while (itr.hasNext()) {
            condition = (String)itr.next();
            if (!PSMLUtil.isEvaluatable(condition, context)) continue;
            return (String)this._nextScenes.get(condition);
        }
        return (String)this._nextScenes.get(null);
    }
}

