/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.resource;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import tsukuba_bunko.peko.InitializationError;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.resource.LocationResources;
import tsukuba_bunko.peko.resource.MessageIDs;
import tsukuba_bunko.resource.Resources;
import tsukuba_bunko.util.ResourceLocator;

public class LocationConfigurator {
    protected File detectInstallDirectory() {
        File baseLocation = null;
        try {
            ResourceLocator locator = ResourceLocator.newInstance();
            baseLocation = locator.findLocation("tsukuba_bunko/peko/PekoSystem.class");
            baseLocation = baseLocation.isFile() ? baseLocation.getParentFile().getParentFile() : baseLocation.getParentFile();
        }
        catch (Exception e) {
            Logger.fatal(MessageIDs.RES0006F, (Throwable)e);
            throw new InitializationError("fail to detect install directory.", e);
        }
        Logger.debug("install dir: " + baseLocation.getAbsolutePath());
        return baseLocation;
    }

    protected URL configureDirectoryURL(String directory, File installDir) {
        File dataDirectory = new File(installDir, directory);
        Logger.debug("dir: " + dataDirectory);
        if (dataDirectory.isDirectory()) {
            try {
                return dataDirectory.toURL();
            }
            catch (MalformedURLException mue) {
                InitializationError ie = new InitializationError("invalid data directory.", mue);
                Logger.fatal(MessageIDs.RES0008F, new Object[]{directory}, ie);
                throw ie;
            }
        }
        if (dataDirectory.isFile()) {
            try {
                return new URL("jar:" + dataDirectory.toURL().toString() + "!/");
            }
            catch (MalformedURLException mue) {
                InitializationError ie = new InitializationError("invalid data directory.", mue);
                Logger.fatal(MessageIDs.RES0008F, new Object[]{directory}, ie);
                throw ie;
            }
        }
        InitializationError ie = new InitializationError("invalid data directory.");
        Logger.fatal(MessageIDs.RES0008F, new Object[]{directory}, ie);
        throw ie;
    }

    protected File ensureSaveDirectory(String directory, File installDir) {
        File saveDir = new File(installDir, directory);
        if (saveDir.exists()) {
            if (saveDir.isDirectory()) {
                return saveDir;
            }
            InitializationError ie = new InitializationError("already exist file.");
            Logger.fatal(MessageIDs.RES0012F, (Throwable)ie);
            throw ie;
        }
        if (!saveDir.mkdir()) {
            InitializationError ie = new InitializationError("fail to create dir.");
            Logger.fatal(MessageIDs.RES0013F, (Throwable)ie);
            throw ie;
        }
        return saveDir;
    }

    public LocationResources configure(Resources systemResources) {
        LocationResources locations = new LocationResources();
        File installDir = this.detectInstallDirectory();
        String[] keys = new String[]{"scenes", "images", "sounds", "misc"};
        URL url = null;
        String value = null;
        int i = 0;
        while (i < keys.length) {
            value = (String)systemResources.getResource("peko.system.location." + keys[i]);
            if (value == null) {
                InitializationError ie = new InitializationError("directory is not specified.");
                Logger.fatal(MessageIDs.RES0011F, new Object[]{keys[i]}, ie);
                throw ie;
            }
            url = this.configureDirectoryURL(value, installDir);
            Logger.debug(url.toString());
            locations.setResource("peko.system.location." + keys[i], url);
            ++i;
        }
        String saveDirectory = (String)systemResources.getResource("peko.system.location.save");
        if (saveDirectory == null) {
            saveDirectory = "save";
        }
        locations.setResource("peko.system.location.save", this.ensureSaveDirectory(saveDirectory, installDir));
        locations.setResource("peko.system.location.install", installDir);
        return locations;
    }
}

