/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.resource;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.resource.ResourceManager;

public class FontManager {
    private static FontManager _instance = null;
    private Map _fonts = null;
    private Set _fontFamilies = null;
    private Map _bundledFonts = null;
    static /* synthetic */ Class class$0;

    protected FontManager() {
    }

    public Font getFont(Map attributes) {
        Font font = (Font)this._fonts.get(attributes);
        if (font == null) {
            String family = (String)attributes.get(TextAttribute.FAMILY);
            Logger.debug("[font] search font: \"" + family + "\"");
            if (family == null) {
                Logger.debug("[font] not specified font family. using serif family (default)");
                attributes.put(TextAttribute.FAMILY, "Serif");
            }
            if (this._bundledFonts.keySet().contains(family)) {
                Logger.debug("[font] using bundled font");
                attributes.remove(TextAttribute.FAMILY);
                font = ((Font)this._bundledFonts.get(family)).deriveFont(attributes);
                attributes.put(TextAttribute.FAMILY, family);
            } else if (this._fontFamilies.contains(family)) {
                Logger.debug("[font] using system family");
                font = new Font(attributes);
            } else {
                Logger.error("[font] invalid font family specified." + family);
                Logger.debug("[font] using serif family (default)");
                attributes.remove(TextAttribute.FAMILY);
                font = new Font("Serif", 1, 0).deriveFont(attributes);
                attributes.put(TextAttribute.FAMILY, family);
            }
            this._fonts.put(attributes, font);
        }
        return font;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize() {
        block16: {
            resources = ResourceManager.getInstance();
            this._fontFamilies = new HashSet<E>(89);
            locale = (Locale)resources.getResource("peko.system.locale");
            if (locale == null) {
                locale = Locale.getDefault();
            }
            families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(locale);
            i = 0;
            while (true) {
                if (i >= families.length) {
                    this._bundledFonts = new HashMap<K, V>(89);
                    additional = (List)resources.getResource("peko.system.fonts", true);
                    if (additional != null && !additional.isEmpty()) {
                        fontStream = null;
                        basedir = resources.getLocationResources().getMiscDirecotryURL();
                        fontPath = null;
                        itr = additional.iterator();
                        break;
                    }
                    break block16;
                }
                this._fontFamilies.add(families[i]);
                ++i;
            }
            while (itr.hasNext()) {
                block23: {
                    block18: {
                        block22: {
                            block17: {
                                try {
                                    try {
                                        block21: {
                                            block20: {
                                                fontPath = (String)itr.next();
                                                if (fontPath == null) break block20;
                                                if (fontPath.length() != 0) break block21;
                                            }
                                            var10_12 = null;
                                            if (fontStream == null) continue;
                                            break block17;
                                        }
                                        Logger.debug("[font] loading font \"" + fontPath + "\".");
                                        fontStream = new URL(basedir, fontPath).openStream();
                                        font = Font.createFont(0, fontStream);
                                        this._bundledFonts.put(font.getAttributes().get(TextAttribute.FAMILY), font);
                                    }
                                    catch (Exception e) {
                                        Logger.warn("[font] fail to load font \"" + fontPath + "\".", (Throwable)e);
                                    }
                                    break block18;
                                }
                                catch (Throwable var11_14) {
                                    var10_12 = null;
                                    if (fontStream != null) {
                                        try {
                                            fontStream.close();
                                        }
                                        catch (Exception e) {
                                            Logger.error("[font] fail to close font stream. \"" + fontPath + "\".", (Throwable)e);
                                        }
                                        fontStream = null;
                                    }
                                    throw var11_14;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [2 : 301->309)] { 
lbl58:
                            // 1 sources

                            fontStream.close();
                            break block22;
lbl60:
                            // 1 sources

                            catch (Exception e) {
                                Logger.error("[font] fail to close font stream. \"" + fontPath + "\".", (Throwable)e);
                            }
                        }
                        fontStream = null;
                        continue;
                    }
                    var10_12 = null;
                    if (fontStream == null) continue;
                    ** try [egrp 2[TRYBLOCK] [2 : 301->309)] { 
lbl69:
                    // 1 sources

                    fontStream.close();
                    break block23;
lbl71:
                    // 1 sources

                    catch (Exception e) {
                        Logger.error("[font] fail to close font stream. \"" + fontPath + "\".", (Throwable)e);
                    }
                }
                fontStream = null;
            }
        }
        this._fonts = new WeakHashMap<K, V>(89);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FontManager getInstance() {
        if (_instance != null) return _instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("tsukuba_bunko.peko.resource.FontManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_instance != null) return _instance;
            _instance = new FontManager();
            _instance.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }
}

