/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.resource;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import tsukuba_bunko.peko.Logger;

public class ColorManager {
    private static ColorManager _instance = null;
    private Map _cache = null;
    static /* synthetic */ Class class$0;

    private ColorManager() {
    }

    private void initialize() {
        this._cache = new HashMap(89);
        this._cache.put("black", new WeakReference<Color>(Color.black));
        this._cache.put("white", new WeakReference<Color>(Color.white));
        this._cache.put("red", new WeakReference<Color>(Color.red));
        this._cache.put("blue", new WeakReference<Color>(Color.blue));
        this._cache.put("green", new WeakReference<Color>(Color.green));
        this._cache.put("yellow", new WeakReference<Color>(Color.yellow));
        this._cache.put("gray", new WeakReference<Color>(Color.gray));
        this._cache.put("darkGray", new WeakReference<Color>(Color.darkGray));
        this._cache.put("lightGray", new WeakReference<Color>(Color.lightGray));
        this._cache.put("cyan", new WeakReference<Color>(Color.cyan));
        this._cache.put("magenta", new WeakReference<Color>(Color.magenta));
        this._cache.put("orange", new WeakReference<Color>(Color.orange));
        this._cache.put("pink", new WeakReference<Color>(Color.pink));
        this._cache.put(null, new WeakReference<Color>(Color.black));
    }

    public Color getColor(String name) {
        Color color = null;
        Object cache = this._cache.get(name);
        if (cache != null) {
            color = (Color)((WeakReference)cache).get();
        }
        if (color == null) {
            if (name.startsWith("#")) {
                try {
                    color = new Color(Integer.parseInt(name.substring(1), 16));
                    WeakReference<Color> ref = new WeakReference<Color>(color);
                    this._cache.put(name, ref);
                }
                catch (Exception e) {
                    Logger.error("[resource] invalid color value specified. :" + name, (Throwable)e);
                    Logger.debug("[resource] using default color. (black)");
                    color = Color.black;
                }
            } else {
                Logger.error("[resource] invalid color name specified. :" + name);
                Logger.debug("[resource] using default color. (black)");
                color = Color.black;
            }
        }
        return color;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColorManager getInstance() {
        if (_instance != null) return _instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("tsukuba_bunko.peko.resource.ColorManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_instance != null) return _instance;
            _instance = new ColorManager();
            _instance.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }
}

