/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.text;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.text.Line;
import tsukuba_bunko.peko.canvas.text.Marker;
import tsukuba_bunko.peko.canvas.text.Page;

public class TextCanvas
extends JComponent {
    private Page _page = null;
    private List _lines = null;
    private AlphaComposite _alphaComposite = AlphaComposite.getInstance(4, 0.5f);
    private Dimension _size = new Dimension();
    private Point _location = new Point(0, 0);
    private Insets _padding = new Insets(0, 0, 0, 0);
    private FontRenderContext _frc = null;
    private Marker _marker = null;

    public TextCanvas() {
        this.initialize();
    }

    public FontRenderContext getFontRenderContext() {
        if (this._frc == null) {
            TextCanvas textCanvas = this;
            synchronized (textCanvas) {
                if (this._frc == null) {
                    try {
                        Logger.debug("[canvas.text] waiting for create cached FontRenderContext.");
                        this.wait();
                        Logger.debug("[canvas.text] creating cached FontRenderContext done.");
                    }
                    catch (InterruptedException ie) {
                        Logger.error("[canvas.text] interrupted.");
                    }
                }
            }
        }
        return this._frc;
    }

    public AlphaComposite getAlphaComposite() {
        return this._alphaComposite;
    }

    public void updateCanvas() {
        if (!this.isEnabled()) {
            return;
        }
        Logger.debug("[canvas.text] update TextCanvas view");
        this._lines = null;
        this._page.getSize(this._size);
        this._page.getLocation(this._location);
        this._page.getPadding(this._padding);
        this.setForeground(this._page.getForeground());
        this.setBackground(this._page.getBackground());
        float trans = this._page.getTransparency();
        if (this._alphaComposite == null || this._alphaComposite.getAlpha() != trans) {
            this._alphaComposite = AlphaComposite.getInstance(3, trans);
        }
        this._marker.setText("\u25bc", this._page);
    }

    public void updateText() {
        if (!this.isEnabled()) {
            return;
        }
        Logger.debug("[canvas.text] update texts.");
        this._marker.setVisible(false);
        List lines = this._page.getLines();
        int size = lines.size();
        int i = 0;
        while (i < size) {
            ((Line)lines.get(i)).prepare(this._page);
            ++i;
        }
        this._lines = lines;
        PekoSystem.getInstance().getCanvasManager().showTextCanvas();
        this.repaint();
        try {
            TextCanvas textCanvas = this;
            synchronized (textCanvas) {
                this.wait(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._marker.setVisible(true);
    }

    public void setPage(Page page) {
        this._page = page;
        this._page.setTextCanvas(this);
    }

    public Page getPage() {
        return this._page;
    }

    public void paintPageBackground(Graphics g) {
        Dimension size = this._size;
        Point location = this._location;
        Graphics2D g2 = (Graphics2D)g.create(location.x, location.y, size.width, size.height);
        g2.setComposite(this._alphaComposite);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, size.width, size.height);
        g2.dispose();
    }

    private void initialize() {
        this.setLayout(null);
        this.setDoubleBuffered(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this._marker = new Marker();
        this.add(this._marker);
        this._marker.setLocation(0, 0);
        this._marker.setVisible(false);
    }

    public void setVisible(boolean visibility) {
        Logger.debug("[canvas.text] set visibility :" + visibility);
        if (visibility) {
            this._marker.start();
        }
        super.setVisible(visibility);
    }

    public void addNotify() {
        super.addNotify();
        Logger.debug("[canvas.text] added notify to TextCavas");
        if (this._frc == null) {
            Logger.debug("[canvas.text] try create new font render context.");
            TextCanvas textCanvas = this;
            synchronized (textCanvas) {
                if (this._frc == null) {
                    Graphics2D g2 = (Graphics2D)this.getGraphics();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    this._frc = g2.getFontRenderContext();
                    Logger.debug("[canvas] notify all thread waiting at TextCanvas");
                    this.notifyAll();
                }
            }
        }
    }

    public void paint(Graphics g) {
        List lines = this._lines;
        if (lines == null || lines.isEmpty()) {
            return;
        }
        super.paint(g);
    }

    public void paintBorder(Graphics g) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, g, this._location.x, this._location.y, this._size.width, this._size.height);
        }
    }

    public void paintComponent(Graphics g) {
        List lines = this._lines;
        Dimension size = this._size;
        Point location = this._location;
        Insets padding = this._padding;
        Graphics2D g2 = (Graphics2D)g;
        float x = location.x + padding.left;
        float y = location.y + padding.top;
        float tail = 0.0f;
        int length = lines.size();
        Line line = null;
        int i = 0;
        while (i < length) {
            line = (Line)lines.get(i);
            line.draw(g2, x, y += line.getAscent());
            y += line.getDescent();
            tail = line.getAdavance();
            ++i;
        }
        this._marker.setPosition((int)(tail + 5.0f + x), (int)y);
    }
}

