/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage.audio;

import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.AudioClip;

public class SampledAudioClip
extends AudioClip
implements Runnable {
    private int _bufferSize = 65536;
    private Thread _thread = null;
    private boolean _running = false;
    private AudioInputStream _is = null;
    private FloatControl _gainControl = null;
    static /* synthetic */ Class class$0;

    public SampledAudioClip(String id, URL clipURL) {
        super(id, clipURL);
    }

    public void play() {
        if (this._thread != null) {
            return;
        }
        try {
            this._is = AudioSystem.getAudioInputStream(this.getClipURL());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._thread = new Thread(this);
        this._thread.start();
    }

    public void stop() {
        Logger.debug("[canvas.audio] stop audio clip :" + this.getID());
        if (this._gainControl != null) {
            this._gainControl.setValue(this._gainControl.getMinimum());
        }
        this._running = false;
        this._thread = null;
        this._is = null;
    }

    public void run() {
        if (this._is == null) {
            return;
        }
        SourceDataLine line = null;
        AudioInputStream is = this._is;
        Logger.debug("[canvas.audio] clip frame size :" + is.getFrameLength());
        byte[] buffer = new byte[this._bufferSize];
        int readed = -1;
        try {
            try {
                FloatControl ctl;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(clazz, is.getFormat()));
                line.open(is.getFormat(), this._bufferSize);
                this._gainControl = ctl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                line.start();
                this._running = true;
                boolean avaliable = false;
                while (is != null && this._running) {
                    readed = is.read(buffer, 0, this._bufferSize);
                    if (!this._running) break;
                    if (readed == -1) {
                        is.close();
                        if (!this.isLoop()) break;
                        is = AudioSystem.getAudioInputStream(this.getClipURL());
                        continue;
                    }
                    line.write(buffer, 0, readed);
                }
                is.close();
            }
            catch (Exception e) {
                Logger.error("[canvas.audio] fatal error occured during play sampled audio clip.", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (line != null) {
                if (this._running) {
                    line.drain();
                }
                line.stop();
                line.flush();
                line.close();
                line = null;
                buffer = null;
            }
            throw throwable;
        }
        Object var7_10 = null;
        if (line != null) {
            if (this._running) {
                line.drain();
            }
            line.stop();
            line.flush();
            line.close();
            line = null;
            buffer = null;
        }
        this._running = false;
        this._thread = null;
        this._is = null;
        Logger.debug("[canvas.audio] playing data \"" + this.getClipURL() + "\" was finished.");
        this.playingFinished();
    }
}

