/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage.audio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javazoom.jlme.decoder.BitStream;
import javazoom.jlme.decoder.Decoder;
import javazoom.jlme.decoder.Header;
import javazoom.jlme.decoder.SampleBuffer;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.AudioClip;

public class MP3AudioClip
extends AudioClip
implements Runnable {
    private int _bufferSize = 1024;
    private Thread _thread = null;
    private boolean _running = false;
    private BitStream _bitstream = null;
    private Decoder _decoder = null;
    private SourceDataLine _line = null;
    private FloatControl _gainControl = null;
    static /* synthetic */ Class class$0;

    public MP3AudioClip(String id, URL clipURL) {
        super(id, clipURL);
    }

    protected void prepare() throws IOException {
        BufferedInputStream is = new BufferedInputStream(this.getClipURL().openStream(), this._bufferSize);
        this._bitstream = new BitStream(is);
        this._decoder = new Decoder(this._bitstream.readFrame(), this._bitstream);
    }

    public void play() {
        if (this._thread != null) {
            return;
        }
        try {
            this.prepare();
        }
        catch (Exception e) {
            Logger.error("[canvas.stage.audio] fail to play.", (Throwable)e);
            return;
        }
        this._thread = new Thread(this);
        this._thread.start();
    }

    public void stop() {
        Logger.debug("[canvas.audio] stop clip " + this.getID());
        if (this._gainControl != null) {
            this._gainControl.setValue(this._gainControl.getMinimum());
        }
        this._running = false;
        try {
            this._thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._thread = null;
    }

    public void run() {
        boolean first = true;
        int length = 0;
        Header header = null;
        this._running = true;
        while (this._running) {
            try {
                SampleBuffer output = this._decoder.decodeFrame();
                length = output.size();
                if (length == 0) {
                    if (!this.isLoop()) break;
                    this._bitstream.closeFrame();
                    this._bitstream.close();
                    this.prepare();
                    continue;
                }
                if (first) {
                    FloatControl ctl;
                    DataLine.Info info;
                    first = false;
                    Logger.debug("[canvas.stage.audio] frequency: " + this._decoder.getOutputFrequency() + ", channels: " + this._decoder.getOutputChannels());
                    AudioFormat format = new AudioFormat(this._decoder.getOutputFrequency(), 16, this._decoder.getOutputChannels(), true, false);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("javax.sound.sampled.SourceDataLine");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!AudioSystem.isLineSupported(info = new DataLine.Info(clazz, format))) {
                        throw new LineUnavailableException("sorry, the sound format cannot be played");
                    }
                    this._line = (SourceDataLine)AudioSystem.getLine(info);
                    this._gainControl = ctl = (FloatControl)this._line.getControl(FloatControl.Type.MASTER_GAIN);
                    this._line.open(format);
                    this._line.start();
                }
                if (this._running) {
                    this._line.write(output.getBuffer(), 0, length);
                }
                this._bitstream.closeFrame();
                header = this._bitstream.readFrame();
            }
            catch (Exception e) {
                Logger.debug("\u306a\u3093\u304b\u30a8\u30e9\u30fc", e);
                break;
            }
        }
        this._running = false;
        try {
            this._bitstream.close();
            this._bitstream = null;
            this._decoder = null;
        }
        catch (Exception e) {
            Logger.warn("[canvas.stage.audio] fail to close bit stream.", (Throwable)e);
        }
        this._running = false;
        this._thread = null;
        Logger.debug("[canvas.audio] playing data \"" + this.getClipURL() + "\" was finished.");
        this.playingFinished();
    }
}

