/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.stage.Actor;
import tsukuba_bunko.peko.canvas.stage.Effect;
import tsukuba_bunko.peko.canvas.stage.Stage;
import tsukuba_bunko.peko.canvas.stage.effect.ImmediateEffect;
import tsukuba_bunko.peko.canvas.stage.effect.MofingEffect;
import tsukuba_bunko.peko.canvas.stage.effect.PataPataEffect;
import tsukuba_bunko.peko.resource.ResourceManager;

public class StageCanvas
extends JComponent {
    private Stage _stage = null;
    private boolean _usingEffect = false;
    private Map _effects = null;
    private BufferedImage _screen = null;
    private BufferedImage _working = null;
    private Dimension _size = new Dimension();

    public StageCanvas() {
        this.initialize();
    }

    public void setStage(Stage stage) {
        if (this._stage != null) {
            this._stage.dispose();
        }
        this._stage = stage;
        this._stage.setStageCanvas(this);
    }

    public Stage getStage() {
        return this._stage;
    }

    public void setUsingEffect(boolean useEffect) {
        this._usingEffect = useEffect;
    }

    public boolean isUsingEffect() {
        return this._usingEffect;
    }

    private void initialize() {
        ResourceManager resources = ResourceManager.getInstance();
        Dimension canvasSize = (Dimension)resources.getResource("peko.canvas.canvas-size");
        super.setPreferredSize(canvasSize);
        super.setSize(canvasSize);
        this._screen = new BufferedImage(canvasSize.width, canvasSize.height, 1);
        this._working = new BufferedImage(canvasSize.width, canvasSize.height, 1);
        super.setLayout(null);
        this._effects = new HashMap(89);
        Effect effect = new MofingEffect();
        this._effects.put(effect.getName(), effect);
        effect = new PataPataEffect();
        this._effects.put(effect.getName(), effect);
        effect = (Effect)this._effects.get("immediate");
        if (effect == null) {
            effect = new ImmediateEffect();
            this._effects.put("immediate", effect);
        }
        this._effects.put(null, effect);
    }

    public void updateCanvas() {
        this.updateCanvas(null);
    }

    public void updateCanvas(String effectName) {
        Image image;
        if (!this.isEnabled()) {
            return;
        }
        Graphics2D g2 = this._working.createGraphics();
        Dimension size = this.getSize(this._size);
        if (this._stage.getSlide() == null) {
            image = this._stage.getBackgroundImage();
            if (image != null) {
                g2.drawImage(image, 0, 0, this);
            } else {
                g2.setColor(this._stage.getBackgroundColor());
                g2.fillRect(0, 0, size.width, size.height);
            }
            Map actors = this._stage.getActors();
            if (actors != null) {
                Iterator itr = actors.values().iterator();
                Actor actor = null;
                Image looks = null;
                int x = 0;
                int y = 0;
                while (itr.hasNext()) {
                    actor = (Actor)itr.next();
                    looks = actor.getLooksImage();
                    if (looks == null) continue;
                    x = this.computePosition(actor);
                    y = size.height - looks.getHeight(this);
                    g2.drawImage(looks, x, y, this);
                }
            }
        } else {
            image = this._stage.getSlideImage();
            if (image != null) {
                g2.drawImage(image, 0, 0, this);
            } else {
                g2.fillRect(0, 0, size.width, size.height);
            }
        }
        if (this._usingEffect) {
            Effect effect = (Effect)this._effects.get(effectName);
            if (effect != null) {
                effect.process(this, this._screen, this._working);
            } else {
                Logger.error("[canvas.stage] unsuported effect name. :" + effect);
                this._screen.setData(this._working.getRaster());
                this.repaint();
            }
            StageCanvas stageCanvas = this;
            synchronized (stageCanvas) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException ie) {
                    Logger.debug("[canvas.stage] interrupted after effect.", ie);
                }
            }
        }
        this._screen.setData(this._working.getRaster());
        this.repaint();
    }

    public void paintPageBackground(boolean visiblePage) {
        Graphics2D g2 = this._screen.createGraphics();
        g2.drawImage((Image)this._working, 0, 0, this);
        if (visiblePage) {
            PekoSystem.getInstance().getCanvasManager().getTextCanvas().paintPageBackground(g2);
        }
        g2.dispose();
        this.repaint();
    }

    private int computePosition(Actor actor) {
        int halfWidth = actor.getLooksImage().getWidth(this) / 2;
        Dimension size = this.getSize(this._size);
        switch (actor.getPosition()) {
            case 0: {
                return (int)((float)size.width / 2.0f) - halfWidth;
            }
            case 1: {
                return (int)((float)size.width / 4.0f) - halfWidth;
            }
            case 2: {
                return (int)((float)size.width / 4.0f * 3.0f) - halfWidth;
            }
        }
        return (int)actor.getAbsolutePosition() - halfWidth;
    }

    protected void paintComponent(Graphics g) {
        g.drawImage(this._screen, 0, 0, this);
    }
}

