/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.Actor;
import tsukuba_bunko.peko.canvas.stage.AudioPlayer;
import tsukuba_bunko.peko.canvas.stage.ImageManager;
import tsukuba_bunko.peko.canvas.stage.StageCanvas;
import tsukuba_bunko.peko.resource.ColorManager;

public class Stage
implements Serializable {
    private transient StageCanvas _canvas = null;
    private AudioPlayer _audioPlayer = new AudioPlayer();
    private transient Map _actors = new HashMap();
    private HashMap _committedActors = new HashMap();
    private transient String _background = null;
    private String _committedBackground = null;
    private transient Image _backgroundImage = null;
    private transient Color _backgroundColor = null;
    private Color _committedBackgroundColor = null;
    private transient String _slide = null;
    private String _committedSlide = null;
    private transient Image _slideImage = null;

    public void enter(Actor actor) {
        this._actors.put(actor.getName(), actor);
    }

    public Actor getName(String name) {
        return (Actor)this._actors.get(name);
    }

    public Actor exit(String name) {
        Actor actor = (Actor)this._actors.remove(name);
        if (actor != null) {
            actor.disposeLooks();
        }
        return actor;
    }

    public void exitAll() {
        String[] names = this._actors.keySet().toArray(new String[this._actors.size()]);
        int i = 0;
        while (i < names.length) {
            this.exit(names[i]);
            ++i;
        }
    }

    public Actor getActor(String name) {
        return (Actor)this._actors.get(name);
    }

    public Map getActors() {
        return this._actors;
    }

    public void setBackgroundImage(String image) {
        Image background;
        ImageManager images = ImageManager.getInstance();
        if (this._backgroundImage != null && !this._background.equals(image)) {
            images.putImage(this._background, this._backgroundImage);
            this._backgroundImage = null;
        }
        if ((background = images.getImage(image)) != null) {
            this._backgroundImage = background;
            this._background = image;
            this._backgroundColor = null;
        } else if (background == null) {
            Logger.error("[canvas.stage] invalid background-image :" + image);
            this._backgroundColor = Color.black;
            this._background = "black";
        }
    }

    public Image getBackgroundImage() {
        return this._backgroundImage;
    }

    public void setBackgroundColor(String color) {
        if (this._backgroundImage != null) {
            ImageManager images = ImageManager.getInstance();
            images.putImage(this._background, this._backgroundImage);
            this._backgroundImage = null;
        }
        ColorManager colors = ColorManager.getInstance();
        this._backgroundColor = colors.getColor(color);
        this._background = color;
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public void showSlide(String slide) {
        ImageManager images = ImageManager.getInstance();
        if (this._slide != null && !this._slide.equals(slide)) {
            images.putImage(this._slide, this._slideImage);
        }
        this._slideImage = images.getImage(slide);
        this._slide = slide;
    }

    public void hideSlide() {
        if (this._slideImage != null) {
            ImageManager images = ImageManager.getInstance();
            images.putImage(this._slide, this._slideImage);
        }
        this._slide = null;
        this._slideImage = null;
    }

    public String getSlide() {
        return this._slide;
    }

    public Image getSlideImage() {
        return this._slideImage;
    }

    public void playBGM(String id, String clipName, boolean loop) {
        this._audioPlayer.playBGM(id, clipName, loop);
    }

    public void stopBGM(String id) {
        this._audioPlayer.stop(id);
    }

    public void stopSE(String id) {
        this._audioPlayer.stop(id);
    }

    public void playSE(String id, String clipName, boolean loop) {
        this._audioPlayer.playSE(id, clipName, loop);
    }

    public void setAudioPlayer(AudioPlayer audioPlayer) {
        this._audioPlayer = audioPlayer;
    }

    public AudioPlayer getAudioPlayer() {
        return this._audioPlayer;
    }

    void setStageCanvas(StageCanvas canvas) {
        this._canvas = canvas;
    }

    public StageCanvas getStageCanvas() {
        return this._canvas;
    }

    public void updateCanvas() {
        this._canvas.updateCanvas(null);
    }

    public void updateCanvas(String effect) {
        if (this._canvas != null) {
            Logger.debug("[canvas.stage] effect :" + effect);
            this._canvas.updateCanvas(effect);
        }
    }

    public void commit() {
        this._committedActors.clear();
        this._committedActors.putAll(this._actors);
        this._committedBackground = this._background;
        this._committedBackgroundColor = this._backgroundColor;
        this._committedSlide = this._slide;
    }

    void dispose() {
        Iterator itr = this._actors.values().iterator();
        while (itr.hasNext()) {
            ((Actor)itr.next()).disposeLooks();
        }
        if (this._backgroundImage != null) {
            ImageManager images = ImageManager.getInstance();
            images.putImage(this._background, this._backgroundImage);
        }
        this._audioPlayer.stopAll();
    }

    public void prepare() {
        if (this._actors == null) {
            this._actors = (Map)this._committedActors.clone();
        }
        Iterator itr = this._actors.values().iterator();
        while (itr.hasNext()) {
            ((Actor)itr.next()).prepare();
        }
        if (this._committedBackgroundColor == null) {
            this.setBackgroundImage(this._committedBackground);
        } else {
            this._background = this._committedBackground;
            this._backgroundColor = this._committedBackgroundColor;
        }
        if (this._committedSlide != null) {
            this.showSlide(this._committedSlide);
        }
        this.updateCanvas();
    }
}

