/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.awt.Image;
import java.io.Serializable;
import tsukuba_bunko.peko.canvas.stage.ImageManager;

public class Actor
implements Serializable {
    public static final int POSITION_CENTER = 0;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_ABSOLUTE = 3;
    private String _name = null;
    private String _looks = null;
    private transient Image _looksImage = null;
    private int _position = 0;
    private float _absolutePosition = 0.0f;

    public Actor(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is not specified.");
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setLooks(String looks) {
        ImageManager images = ImageManager.getInstance();
        if (this._looks != null && this._looks.equals(looks)) {
            if (this._looksImage == null) {
                this.setLooksImage(images.getImage(looks, true));
            }
        } else {
            if (this._looksImage != null) {
                images.putImage(this._looks, this._looksImage);
            }
            this.setLooksImage(images.getImage(looks, true));
        }
        this._looks = looks;
    }

    public String getLooks() {
        return this._looks;
    }

    public void setLooksImage(Image looks) {
        this._looksImage = looks;
    }

    public Image getLooksImage() {
        return this._looksImage;
    }

    public void setPosition(int position) {
        if (position != 0 && position != 1 && position != 2) {
            throw new IllegalArgumentException("invalid position type is specified.");
        }
        this._position = position;
    }

    public void setPosition(float absolutePosition) {
        this._position = 3;
        this._absolutePosition = absolutePosition;
    }

    public int getPosition() {
        return this._position;
    }

    public float getAbsolutePosition() {
        return this._absolutePosition;
    }

    void disposeLooks() {
        if (this._looksImage != null) {
            ImageManager images = ImageManager.getInstance();
            images.putImage(this._looks, this._looksImage);
            this._looksImage = null;
        }
    }

    void prepare() {
        this.setLooks(this._looks);
    }

    public void copyTo(Actor actor) {
        actor._name = this._name;
        actor._looksImage = this._looksImage;
        actor._looks = this._looks;
        actor._position = this._position;
        actor._absolutePosition = this._absolutePosition;
    }
}

