/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko;

import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.InitializationError;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.CanvasManager;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.ScenarioProcessor;
import tsukuba_bunko.peko.session.Session;
import tsukuba_bunko.peko.session.SessionManager;

public class PekoSystem {
    private static PekoSystem _instance = null;
    private Object[] _versionInfo = null;
    private JFrame _mainWindow = null;
    private CanvasManager _canvasManager = null;
    private ScenarioProcessor _scenarioProcessor = null;
    private SessionManager _sessionManager = null;
    private ActionControler _actionControler = null;
    private boolean _started = false;
    static /* synthetic */ Class class$0;

    protected PekoSystem() {
    }

    public void start() {
        if (this._started) {
            return;
        }
        Point location = (Point)this._sessionManager.getSystemSaveData().getEntry("windowLocation");
        if (location != null) {
            this._mainWindow.setLocation(location);
        } else {
            this._mainWindow.setLocationRelativeTo(null);
        }
        this._mainWindow.show();
        JFrame jFrame = this._mainWindow;
        synchronized (jFrame) {
            try {
                if (!this._mainWindow.isShowing()) {
                    this._mainWindow.wait();
                    Logger.debug("[system] window opened.");
                }
            }
            catch (InterruptedException ie) {
                Logger.debug("[system] interrupted in waiting for opening window.");
            }
        }
        this._actionControler.returnTitle(true);
    }

    public void exit() {
        boolean last = this._actionControler.isActive();
        this._actionControler.setActive(false);
        ResourceManager resources = ResourceManager.getInstance();
        String title = (String)resources.getResource("peko.dialog.exit.title");
        String message = (String)resources.getResource("peko.dialog.exit.message");
        if (JOptionPane.showConfirmDialog(this._mainWindow, message, title, 2) != 0) {
            this._actionControler.setActive(last);
            return;
        }
        this._mainWindow.dispose();
        try {
            this._sessionManager.getSystemSaveData().addEntry("windowLocation", this._mainWindow.getLocation());
            this._sessionManager.saveSystemSaveData();
        }
        catch (Exception e) {
            PekoSystem.showErrorDialog("fail to system save data.", e, false);
        }
        Logger.info("Bye!");
        System.exit(0);
    }

    public void showTitle() {
        try {
            if (this._started) {
                this._scenarioProcessor.exit();
                this._canvasManager.clearAll();
            } else {
                this._canvasManager.getStageCanvas().setUsingEffect(false);
                this._canvasManager.clearAll();
                this._canvasManager.getStageCanvas().setUsingEffect(true);
                this._started = true;
            }
            this._mainWindow.setTitle((String)ResourceManager.getInstance().getResource("game-info.title"));
            boolean first = true;
            while (true) {
                String id;
                if ((id = this._canvasManager.showTitle(first)) == null) {
                    Logger.debug("[system] canceled.");
                    break;
                }
                if ("start".equals(id)) {
                    ResourceManager resources = ResourceManager.getInstance();
                    String startPage = (String)resources.getResource("peko.system.start-scene");
                    if (startPage == null) {
                        Logger.fatal("[system] not specified scenario.start-scene.");
                        throw new InitializationError("[system] not specified scenario.start-scene.");
                    }
                    this._canvasManager.clearAll();
                    this._sessionManager.initializeSession();
                    this._scenarioProcessor.playScenario(startPage, this._sessionManager.getSession());
                    break;
                }
                if ("resume".equals(id)) {
                    if (this.load()) {
                        break;
                    }
                } else if ("exit".equals(id)) {
                    this.exit();
                }
                first = false;
            }
        }
        catch (Exception e) {
            Logger.fatal("[system] fatal error occured during saving states.", (Throwable)e);
            JOptionPane.showMessageDialog(this._mainWindow, "ERROR!", "Error!", 0);
        }
    }

    public void save() {
        try {
            Session session = this._sessionManager.getSession();
            this._canvasManager.saveState(session);
            this._sessionManager.saveCurrentSession();
        }
        catch (Exception e) {
            Logger.fatal("[system] fatal error occured during saving states.", (Throwable)e);
            JOptionPane.showMessageDialog(this._mainWindow, "[system] fatal error occured during saving states.", "Error!", 0);
            return;
        }
        try {
            this._sessionManager.saveSystemSaveData();
        }
        catch (Exception e) {
            Logger.fatal("[system] fatal error occured during saving states.", (Throwable)e);
            PekoSystem.showErrorDialog("A fatal error occured during saving states", e, true);
        }
    }

    public boolean load() {
        boolean result = false;
        try {
            this._actionControler.setPlayModeToNormal();
            if (this._sessionManager.load()) {
                this._scenarioProcessor.exit();
                this._canvasManager.clearAll();
                Session session = this._sessionManager.getSession();
                this._mainWindow.setTitle(String.valueOf(session.getSceneContext().getSceneTitle()) + " - " + ResourceManager.getInstance().getResource("game-info.title"));
                this._canvasManager.resume(session);
                this._scenarioProcessor.playScenario(session.getSceneContext().getSceneName(), session);
                result = true;
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            Logger.fatal("[system] fatal error occured during saving states.", (Throwable)e);
            JOptionPane.showMessageDialog(this._mainWindow, "[system] fatal error occured during saving states.", "Error!", 0);
        }
        return result;
    }

    public void showSystemVersionInfo() {
        ResourceManager resources = ResourceManager.getInstance();
        ImageIcon icon = null;
        URL iconURL = this.getClass().getClassLoader().getResource("pvns-logo.gif");
        if (iconURL != null) {
            icon = new ImageIcon(iconURL, "PVNS Logo");
        }
        JOptionPane.showMessageDialog(this._mainWindow, this._versionInfo, (String)this._versionInfo[0], 1, icon);
    }

    public void showGameVersionInfo() {
        ResourceManager resources = ResourceManager.getInstance();
        Icon icon = (Icon)resources.getResource("game-info.logo", true);
        ArrayList<String> texts = new ArrayList<String>();
        String[] props = new String[]{"game-info.title", "game-info.version", "game-info.publisher", "game-info.copyright"};
        int i = 0;
        while (i < props.length) {
            String var = (String)resources.getResource(props[i], true);
            if (var != null) {
                texts.add(var);
            }
            ++i;
        }
        List additionalInfo = (List)resources.getResource("game-info.additional-info", true);
        if (additionalInfo != null && !additionalInfo.isEmpty()) {
            if (!texts.isEmpty()) {
                texts.add(" ");
            }
            texts.addAll(additionalInfo);
        }
        if (!texts.isEmpty()) {
            JOptionPane.showMessageDialog(this._mainWindow, texts.toArray(), (String)resources.getResource("game-info.title"), 1, icon);
        }
    }

    public Object[] getPekoSystemVersion() {
        return this._versionInfo;
    }

    public JFrame getMainWindow() {
        return this._mainWindow;
    }

    public CanvasManager getCanvasManager() {
        return this._canvasManager;
    }

    public ActionControler getActionControler() {
        return this._actionControler;
    }

    private void prepareVersionInfo() {
        try {
            InputStream is;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("tsukuba_bunko.peko.PekoSystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((is = clazz.getResourceAsStream("version.txt")) != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "Shift_JIS"));
                String line = reader.readLine();
                ArrayList<String> lines = new ArrayList<String>();
                while (line != null) {
                    lines.add(line);
                    line = reader.readLine();
                }
                reader.close();
                is.close();
                this._versionInfo = lines.toArray();
            } else {
                Logger.error("[system] missing version.txt.");
                Logger.debug("[system] using embeded version info.");
                this._versionInfo = new Object[]{"\"Peko\" Visual Novel System", "version 1.0", "All Rights Reserved.", "(c)Copyright by Tsukuba Bunko."};
            }
        }
        catch (IOException ioe) {
            Logger.error("[system] fail to read version info.", (Throwable)ioe);
            Logger.debug("[system] using embeded version info.");
            this._versionInfo = new Object[]{"\"Peko\" Visual Novel System", "version 1.0", "All Rights Reserved.", "(c)Copyright by Tsukuba Bunko."};
        }
    }

    private void prepareMainWindow() {
        JFrame window;
        this._mainWindow = window = new JFrame((String)this._versionInfo[0]);
        window.setDefaultCloseOperation(0);
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent ev) {
                JFrame jFrame = PekoSystem.this._mainWindow;
                synchronized (jFrame) {
                    PekoSystem.this._mainWindow.notify();
                }
            }

            public void windowClosing(WindowEvent ev) {
                PekoSystem.this.exit();
            }
        });
    }

    private void prepareResources() {
        try {
            ResourceManager resources = ResourceManager.getInstance();
        }
        catch (Exception e) {
            throw new InitializationError();
        }
    }

    private void prepareCanvasManager() {
        this._canvasManager = new CanvasManager();
        this._canvasManager.initialize();
    }

    private void prepareScenarioProcessor() {
        this._scenarioProcessor = new ScenarioProcessor();
    }

    private void prepareSessionManager() {
        this._sessionManager = new SessionManager();
    }

    private void prepareActionControler() {
        ActionControler controler = new ActionControler();
        this._canvasManager.getTextCanvas().addMouseListener(controler);
        this._canvasManager.getStageCanvas().addMouseListener(controler);
        this._mainWindow.addKeyListener(controler);
        this._actionControler = controler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PekoSystem getInstance() {
        if (_instance != null) return _instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("tsukuba_bunko.peko.PekoSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_instance != null) return _instance;
            _instance = new PekoSystem();
            _instance.prepareVersionInfo();
            _instance.prepareResources();
            _instance.prepareSessionManager();
            _instance.prepareMainWindow();
            _instance.prepareCanvasManager();
            _instance.prepareActionControler();
            _instance.prepareScenarioProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public static void showErrorDialog(String message, Throwable e, boolean exit) {
        if (message == null) {
            message = e.getMessage();
        }
        StackTraceElement[] stackTrace = e.getStackTrace();
        Object[] messages = new Object[stackTrace.length + 2];
        int i = 0;
        while (i < stackTrace.length) {
            messages[i + 1] = stackTrace[i];
            ++i;
        }
        messages[0] = "Fatal Error :" + message;
        messages[1] = String.valueOf(e.getClass().getName()) + " : " + e.getMessage();
        JOptionPane.showMessageDialog(null, messages, "FATAL ERROR ! -\"Peko\" Visual Novel System", 0);
        if (exit) {
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        Logger.prepare();
        try {
            PekoSystem system = PekoSystem.getInstance();
            Object[] versionInfo = system.getPekoSystemVersion();
            Logger.info((String)versionInfo[0]);
            Logger.info((String)versionInfo[1]);
            system.start();
        }
        catch (Throwable e) {
            PekoSystem.showErrorDialog(null, e, true);
        }
    }
}

