#if !defined( DIRECTSSTP_ )
#define DIRECTSSTP_

#include "ThreadControl.h"
#include "SakuraAPI.h"
#include <windows.h>

// #pragma comment(linker, "/NODEFAULTLIB:libc")

#define WM_KINOKO_GETKINOKONAME (WM_APP+101)
#define WM_KINOKO_GETGHOSTNAME  (WM_APP+102)
#define WM_KINOKO_GETCATEGORY   (WM_APP+103)


class DirectSSTP : public ThreadControl						// DirectSSTP NCAgNX
{
protected:
	// ThreadControl I[o[Ch֐
	virtual DWORD Run();

public:	
	// RXgN^
	DirectSSTP(LPCSTR szSender = "EZSSTP", int n = 1);
	virtual ~DirectSSTP();									// fXgN^
	
	// DirectSSTP ֐										// DirectSSTP p[^
	void InitSSTP(LPCSTR szSender = "EZSSTP", int n = 1);
	
	int SSTP(LPCSTR szBuffer);								// v[eLXgM
	
	int SSTPSend(LPCSTR szScript, LPCSTR szOption = NULL);	// SEND SSTP/1.1
	int SSTPExecute(LPCSTR szCommand, LPCSTR szVer);		// EXECUTE SSTP
	int SSTPExGetName();									// EXECUTE SSTP/1.0
	int SSTPExSetCookie(LPCSTR szEntry, LPCSTR szValue);	// EXECUTE SSTP/1.1
	int SSTPExGetCookie(LPCSTR szEntry);					// EXECUTE SSTP/1.1
	int SSTPExGetVersion();									// EXECUTE SSTP/1.2
	int SSTPExQuiet();										// EXECUTE SSTP/1.3
	int SSTPExRestore();									// EXECUTE SSTP/1.3
	int SSTPGive(LPCSTR szDocument, LPCSTR szSongname);		// GIVE SSTP/1.1
	int SSTPCommunicate(LPCSTR szSentence, LPCSTR szOption = NULL);	// COMMUNICATE SSTP/1.1
	int SSTPCommunicate(int port, LPCSTR szSentence, LPCSTR szOption = NULL);	// COMMUNICATE SSTP/1.2
	
	// ߂l擾
	int IsSynchronized();								// *
	int Synchronize(DWORD dwTimeOut = INFINITE);		// *
	LPCSTR GetSendBuffer();								// ŌɑMXNvgԂ
	LPCSTR GetStatusCode();								// O SSTP ʐM̃Xe[^XR[hԂ
	int GetStatusCodeInt();								// O SSTP ʐM̃Xe[^XR[h int ^ŕԂ
	LPCSTR GetStatusToken(int n);						// O SSTP ʐM̃Xe[^XR[h߂lo
	
	
	// SAKURA API/1.0 native
	int SA_ExecuteRemakeMenu();							// *
	int SA_ExecuteRewriteFMO();							// *

	// SAKURA API/1.1 wrapper
	int SA_GetHeadCollisionRectSakura(RECT *rect);		//   蔻
	int SA_GetFaceCollisionRectSakura(RECT *rect);		//   蔻
	int SA_GetBustCollisionRectSakura(RECT *rect);		//   蔻
	int SA_GetCenterPointSakura(POINT *point);			//  T[tBX S_
	
	int SA_GetHeadCollisionRectKero(RECT *rect);		// ɂイ  蔻
	int SA_GetFaceCollisionRectKero(RECT *rect);		// ɂイ  蔻
	int SA_GetBustCollisionRectKero(RECT *rect);		// ɂイ  蔻
	int SA_GetCenterPointKero(POINT *point);			// ɂイ T[tBX S_

	int SA_GetGhostState();								// S[Xǧ݂̃Xe[gԂ

	// SAKURA API/1.2 wrapper
	int SA_GetAKFCenterPointSakura(POINT *point);		//  ΂̂̈ S_
	int SA_GetAKFCenterPointKero(POINT *point);			// ɂイ ΂̂̈ S_

	// SAKURA API/1.3 native
	DWORD SA_GetProcessID();							// vZXIDԂ
	DWORD SA_GetSharedMemory(int memoryslot);			// Xbgւ̃|C^Ԃ

	// SAKURA API/1.3 wrapper
	LPCSTR SA_ReadMemorySlot(int memoryslot);					// Xbgǂݏo
	int SA_WriteMemorySlot(int memoryslot, LPCSTR szBuffer);	// Xbg
	int SA_NotifyEvent();								// Cxgʒm
	

	// ÂALǂӁASSP
	int IsSakura();										// B ݂邩H
	int IsKinoko();										// ̂ ݂邩H
	int IsNekodorif();									// Lǂ ݂邩H
	int IsSSP();										// SSP ݂邩H
	
	HWND GetSakuraWindow(int n = 1);					// B  hWnd 擾
	HWND GetKinokoWindow(int n = 1);					// ̂  hWnd 擾
	HWND GetNekodorifWindow();							// Lǂ  hWnd 擾

	LPCSTR GetSakuraGhost(int n = 1);					// B ̃S|Xg擾
	LPCSTR GetKinokoName(int n = 1);					// ̂ ̖̂擾
	LPCSTR GetKinokoTarget(int n = 1);					// ̂ z肷S[Xĝ̖擾
	LPCSTR GetKinokoCategory(int n = 1);				// ̂ ̃JeS擾

private:
	int GetReturnWindow();								// l߂ׂEBhEnhԂ
	int SendDirectSSTP();								// DirectSSTP M
														// CX^XƂ̃EBhEvV[W
	LRESULT WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
														// ftHgEBhEvV[W
	static LRESULT CALLBACK DefaultWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

	char	m_Sender[256];
	char	m_SakuraAddr[256];
	int		m_DirectSSTPTarget;

	HWND	m_hWnd;

	UINT	WM_SAKURAAPI;
	
	char	m_SendText[2048];
	char	m_ReturnText[256];
	char	m_ReturnBuf[256];
	int		m_ErrorCode;

	char	m_SakuraGhost[256];
	char	m_KinokoName[256];
	char	m_KinokoTarget[256];
	char	m_KinokoCategory[256];

	char	m_MemorySlot[8192];

	int		m_createflag;

	HINSTANCE hInstance;		// CX^Xnh
	static int uid;				// CX^XJE^[
};

#endif // DirectSSTP_
