<?php

/* -------------------------------------------------------------------------
	!!!The character encoding of this file must be `INT_ENC`
	defined in Config.inc.php (the default value is UTF-8)!!!

	HTML出力のテンプレート
	for PC2M Website Transcoder for Mobile Clients
	Copyright (C) 2005-2007 ucb.rcdtokyo and the contributors
	http://www.rcdtokyo.com/pc2m/note/
------------------------------------------------------------------------- */

// 画面上部のFORM要素
$form_adds = null;

// 画像表示時
if ($new_image) {

	// 画像形式の選択プルダウン
	if ($client->screen['gif_support']
		+ $client->screen['jpg_support']
		+ $client->screen['png_support'] > 1) {
		$form_adds .= '<select name="'.KEY_PREFIX.'t">';
		if ($client->screen['gif_support']) {
			$form_adds .= '<option value="1"'.($new_image[2] == 1 ? ' selected="selected"' : null).'>GIF</option>';
		}
		if ($client->screen['jpg_support']) {
			$form_adds .= '<option value="2"'.($new_image[2] == 2 ? ' selected="selected"' : null).'>JPEG</option>';
		}
		if ($client->screen['png_support']) {
			$form_adds .= '<option value="3"'.($new_image[2] == 3 ? ' selected="selected"' : null).'>PNG</option>';
		}
		$form_adds .= '</select>';
	}

	// 画質を「高・中・低」などから選択させる場合のプルダウンの例
	// 値は、「50%」のように、0～100の数値に「%」記号を続けてください。
	$form_adds .= '<select name="'.KEY_PREFIX.'q">
		<option value="">自動
		<option value="75%"'.($image_quality == '75%' ? ' selected="selected"' : null).'>高</option>
		<option value="50%"'.($image_quality == '50%' ? ' selected="selected"' : null).'>中</option>
		<option value="35%"'.($image_quality == '35%' ? ' selected="selected"' : null).'>低</option>
		</select><br>';

	// 画像の縦横サイズの入力フィールド
	$form_adds .= '<input type="text" name="'.
		KEY_PREFIX.'w" size="3" maxlength="3" istyle="4" value="'.$new_image[0].
		'">x<input type="text" name="'.
		KEY_PREFIX.'h" size="3" maxlength="3" istyle="4" value="'.$new_image[1].'">'.

		// 画質を数値で入力させる場合の入力フィールドの例
		// 数値のみの入力では
		// 変換先の画像形式がJPEGなら入力値はJPEG圧縮率となります。有効範囲は0～100です。
		// 変換先の画像形式がGIF|PNGなら入力値はパレット色数となります。有効範囲は1～256です。
		// 「50%」のように、数値に「%」記号が続く入力では
		// 変換先の画像形式がJPEGなら入力値はJPEG圧縮率となります。
		// 変換先の画像形式がGIF|PNGなら、入力値を基に元画像と相対的なパレット色数が計算されます。
		// この場合はいずれも、入力値の有効範囲は0～100です。
		// 'q=<input type="text" name="'.
		// KEY_PREFIX.'q" size="2" maxlength="4" istyle="4" value="'.$image_quality.'">'.
		'<br>';

// HTML|RSS表示時
} else {

	// ページ分割時の開始文字数|検索語の入力フィールド
	if ($next_link) {
		$form_adds .= '<input type="text" name="'.KEY_PREFIX.'s" size="4" istyle="4" value="'.
		$next_trim.'">/'.number_format($total_chars).'字<br>';
	}
}

// 設定画面へのリンク
$setup_link = '<a href="'.$script_self.KEY_PREFIX.'a=s'.(isset($_SESSION)? '&amp;'.KEY_PREFIX.'u='.$_history_key: null).'">設</a>';

header('Content-Type:text/html;charset=Shift_JIS');
if ($client->preferred_markup == 'xhtml') {
	if ($client->dev_type == 'vodafone') {
		echo '<?xml version="1.0" encoding="Shift_JIS"?>';
		echo '<!DOCTYPE html PUBLIC "-//J-PHONE//DTD XHTML Basic 1.0 Plus//EN" "xhtml-basic10-plus.dtd">';
		echo '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">';
	} else {
		echo '<?xml version="1.0" encoding="Shift_JIS"?>';
		echo '<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">';
		echo '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">';
	}
} else {
	echo '<html>';
}
?><head>
<meta name="robots" content="noindex,nofollow,noarchive">
<title><?php echo $title ?></title>
</head>
<body<?php
if ($body_elements and !$_is_error) {
	echo (isset($body_elements['background'])? ' background="'.$body_elements['background'].'"': null);
	echo (isset($body_elements['bgcolor'])? ' bgcolor="'.$body_elements['bgcolor'].'"': null);
	echo (isset($body_elements['text'])? ' text="'.$body_elements['text'].'"': null);
	echo (isset($body_elements['link'])? ' link="'.$body_elements['link'].'"': null);
	echo (isset($body_elements['alink'])? ' alink="'.$body_elements['alink'].'"': null);
	echo (isset($body_elements['vlink'])? ' vlink="'.$body_elements['vlink'].'"': null);
}
?>>
<form action="<?php echo basename($_SERVER['SCRIPT_NAME']) ?>"><?php echo $form_hidden ?><?php
echo ($client->dev_type == 'au')? '<a name="'.KEY_PREFIX.'t" href="#'.KEY_PREFIX.'b" accesskey="8">下</a>'.$setup_link: null ?>
<?php echo $form_adds ?>
<input type="text" name="<?php echo KEY_PREFIX ?>u" size="4" istyle="3" value="<?php
echo $remote_url ?>"><input type="submit" value="GO"><?php
echo ($client->dev_type != 'au')? $setup_link.'<a name="'.KEY_PREFIX.'t" href="#'.KEY_PREFIX.'b" accesskey="8">下</a>': null ?>
</form>
<hr>
<?php
echo ($rss_url? '<a href="'.$rss_url.'">RSS</a>|': null).
($remote_url? '<a href="'.$script_self.KEY_PREFIX.'a=o&amp;'.KEY_PREFIX.'u='.urlencode($remote_url).'">ﾂｰﾙ</a><hr>': null);
?>
<?php echo $content ?>
<hr>
<a name="<?php echo KEY_PREFIX ?>b" href="#<?php echo KEY_PREFIX ?>t" accesskey="2">上</a><?php
echo $start_link? '<a href="'.$start_link.'" accesskey="1">始</a>': null ?><?php
echo $next_link? '<a href="'.$next_link.'" accesskey="9">次</a>': null ?><?php
echo $copy_link? '<a href="'.$copy_link.'" accesskey="5">写</a>': null ?><?php
echo $remote_url? '<a href="r.php?'.urlencode($remote_url).'">直</a>': null ?><?php
echo isset($_SESSION)? '<a href="'.$script_self.KEY_PREFIX.'a=h">履</a>': null ?><a href="<?php
echo $script_self ?>" accesskey="6">TOP</a>

</body>
</html>
