<?php

/* -------------------------------------------------------------------------
	ClientDetect class
	a part of PC2M Web Content Converter for Mobile Clients
	Copyright (C) 2005-2006 ucb@rcdtokyo.com
	http://www.rcdtokyo.com/pc2m/note/
------------------------------------------------------------------------- */

class ClientDetect {

	var $dev_type;
	var $dev_info;
	var $cache_size;
	var $screen;

/* -------------------------------------------------------------------------
	CONSTRUCTOR
------------------------------------------------------------------------- */

	function ClientDetect() {

		if (!isset($_SERVER['HTTP_USER_AGENT'])) {
			$this->dev_type = 'mozilla';
		} else {
			if (preg_match('/^DoCoMo\/[\.\d]+[\s\/](.+)/', $_SERVER['HTTP_USER_AGENT'], $matches)) {
				/* DoCoMo/1.0/[model]/[cache]/[mode]/[chars] */
				$this->dev_type = 'docomo';
				$this->dev_info = explode('/', $matches[1]);
				/* DoCoMo/2.0 [model]([cache];[mode];[chars]) */
				if (preg_match('/^([^\(]+)\((.+)\)/', $this->dev_info[0], $matches)) {
					$this->dev_info = explode(';', $matches[2]);
					array_unshift($this->dev_info, $matches[1]);
				}

			/* some vodafone devices have 'UP.Browser' string in the middle of UA */
			} elseif (preg_match('/^(?:KDDI-\w+\s)?UP\.Browser\//', $_SERVER['HTTP_USER_AGENT'])) {
				$this->dev_type = 'au';

			/* not all vodafone device has 'Vodafone' or 'J-PHONE' in UA */
			} elseif (isset($_SERVER['X-JPHONE-MSNAME'])) {
				$this->dev_type = 'vodafone';
				$this->dev_info = explode('/', $_SERVER['HTTP_USER_AGENT']);

			} elseif (preg_match('/^Mozilla\/(\d+)\.(\d+)\s(.+)$/', $_SERVER['HTTP_USER_AGENT'], $matches)) {
				$this->dev_type = 'mozilla';
				/* prepared only in case of further determination */
				$this->dev_info[0] = (int) $matches[1]; // major version
				$this->dev_info[1] = (int) $matches[2]; // minor version
				$this->dev_info[2] = $matches[3]; // subsequent strings
			}
		}
	}

/* -------------------------------------------------------------------------
	getCacheSize
------------------------------------------------------------------------- */

	function getCacheSize() {

		if ($this->cache_size === null) {
			switch ($this->dev_type) {
				case 'docomo':
					$this->cache_size = (isset($this->dev_info[1])
						and preg_match('/^c(\d{1,})$/', $this->dev_info[1], $matches))?
						$matches[1] * 1000:
						5000;
					break;
				case 'au':
					/* returns the minimum spec if the server variable is unavailable */
					$this->cache_size = isset($_SERVER['HTTP_X_UP_DEVCAP_MAX_PDU'])?
						$_SERVER['HTTP_X_UP_DEVCAP_MAX_PDU']:
						7500;
					break;
				case 'vodafone':
					/* returns 12KB if packet compatible, otherwise 6KB */
					$this->cache_size = count($this->dev_info) > 3?
						12000:
						6000;
					break;
				case 'mozilla':
					$this->cache_size = 10000;
					break;
				default:
					$this->cache_size = 5000;
			}
		}
		return $this->cache_size;
	}

/* -------------------------------------------------------------------------
	getScreenInfo
------------------------------------------------------------------------- */

	function getScreenInfo() {

		if ($this->screen === null) {
			switch ($this->dev_type) {
				case 'docomo':
					include_once 'DevInfo_DoCoMo.inc.php';
					if (isset($_dev_info[$this->dev_info[0]])) {
						$this->screen = array(
							"width" => $_dev_info[$this->dev_info[0]][0],
							"color" => $_dev_info[$this->dev_info[0]][1],
							"gif_support" => $_dev_info[$this->dev_info[0]][2],
							"jpg_support" => $_dev_info[$this->dev_info[0]][3],
							"png_support" => $_dev_info[$this->dev_info[0]][4],
						);
					/* if the model name is not in the list, it is supposed to be a new one
					and returns average spec of recent devices */
					} else {
						$this->screen = array(
							"width" => 240,
							"color" => 65536,
							"gif_support" => true,
							"jpg_support" => true,
							"png_support" => false,
						);
					}
					break;
				case 'au':
					/* if the server variable is unavailable
					the minimum spec of known color device will be applied */
					$_screen_size = isset($_SERVER['HTTP_X_UP_DEVCAP_SCREENPIXELS'])?
						explode(',', $_SERVER['HTTP_X_UP_DEVCAP_SCREENPIXELS']):
						array(96, null);
					$_screen_depth = isset($_SERVER['HTTP_X_UP_DEVCAP_SCREENDEPTH'])?
						explode(',', $_SERVER['HTTP_X_UP_DEVCAP_SCREENDEPTH']):
						array(8, null);
					$_http_accept = isset($_SERVER['HTTP_ACCEPT'])?
						$_SERVER['HTTP_ACCEPT']:
						null;
					$this->screen = array(
						"width" => (int)$_screen_size[0],
						"color" => pow(2, (int)$_screen_depth[0]),
						"gif_support" => preg_match('/image\/gif/', $_http_accept) ? true : false,
						"jpg_support" => preg_match('/image\/jpeg/', $_http_accept) ? true : false,
						"png_support" => true,
					);
					break;
				case 'vodafone':
					/* if the server variable is unavailable
					the minimum spec of known color device will be applied */
					$_screen_size = isset($_SERVER['X-JPHONE-DISPLAY'])?
						explode('*', $_SERVER['X-JPHONE-DISPLAY']):
						array(96, null);
					$_screen_depth = isset($_SERVER['X-JPHONE-COLOR'])?
						(int)preg_replace('/^[C|G](\d+)$/',"$1",$_SERVER['X-JPHONE-COLOR']):
						256;
					$_http_accept = isset($_SERVER['HTTP_ACCEPT'])?
						$_SERVER['HTTP_ACCEPT']:
						null;
					$this->screen = array(
						"width" => $_screen_size[0],
						"color" => $_screen_depth,
						/* newer devices (UA begins with other than 'J-PHONE') are GIF capable */
						"gif_support" => $this->dev_info[0] != null
							and $this->dev_info[0] != 'J-PHONE' ? true : false,
						/* earliest devices (UA begins with 'J-PHONE/2.0/') are JPEG incapable */
						"jpg_support" => $this->dev_info[0] != null
							and ($this->dev_info[0] != 'J-PHONE' or $this->dev_info[1] != '2.0') ? true : false,
						"png_support" => true,
					);
					break;
				case 'mozilla':
					$this->screen = array(
						"width" => 240,
						"color" => 65536,
						"gif_support" => true,
						"jpg_support" => true,
						"png_support" => true,
					);
					break;
				default:
					$this->screen = array(
						"width" => 96,
						"color" => 256,
						"gif_support" => true,
						"jpg_support" => true,
						"png_support" => true,
					);
			}
		}
		return $this->screen;
	}
}

?>
