/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import paraselene.Page;
import paraselene.ajax.Ajax;
import paraselene.ajax.data.Exec;
import paraselene.ajax.data.PostBack;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageID;
import paraselene.ui.PageBypassedDiv;

public class History
implements Serializable {
    private static final long serialVersionUID = 2L;
    private ArrayList<Page> hist = new ArrayList();
    private int histry_no;
    private ReentrantLock lock = new ReentrantLock();
    private ArrayList<Page> popup = new ArrayList();
    volatile boolean drop_f = false;
    volatile String session_id;

    private void comet_stop(Page p) {
        StringBuilder buf = new StringBuilder("paraselene.comet_stop('");
        buf = buf.append(p.getUniqueKey());
        buf = buf.append("');");
        Ajax.addComet(this.session_id, new PostBack(new Exec(buf.toString())));
    }

    boolean tryLock() {
        if (this.lock.isHeldByCurrentThread()) {
            return true;
        }
        Option.trace("call tryLock ", new Object[0]);
        boolean ret = this.lock.tryLock();
        Option.trace("tryLock %s ", new Object[]{ret});
        return ret;
    }

    void lock() {
        if (this.lock.isHeldByCurrentThread()) {
            return;
        }
        Option.trace("call lock ", new Object[0]);
        this.lock.lock();
        Option.trace("locked ", new Object[0]);
    }

    void unlock() {
        if (!this.lock.isHeldByCurrentThread()) {
            return;
        }
        Option.trace("call unlock ", new Object[0]);
        this.lock.unlock();
        Option.trace("unlocked ", new Object[0]);
    }

    private History() {
    }

    History(int n, String s) {
        this.histry_no = n;
        this.session_id = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSatellitePage(Page page) {
        if (page == null) {
            return;
        }
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            this.removePopup(page);
            this.setInfo(page);
            this.popup.add(page);
        }
        Option.trace("addSatellitePage %d %s", this.hashCode(), page.getUniqueKey());
    }

    private void initSatellitePage(Page parent) {
        if (parent == null) {
            return;
        }
        PageBypassedDiv[] div = parent.getPageBypassedDiv();
        for (int i = 0; i < div.length; ++i) {
            this.initSatellitePage(div[i].getBypassPage());
        }
        if (parent != parent.getParentPage()) {
            this.addSatellitePage(parent);
        }
    }

    public void removeSatellitePage(Page page) {
        if (page == null) {
            return;
        }
        if (page.getAjaxSupport() == Page.AjaxSupport.SERVER_PUSH) {
            this.comet_stop(page);
        }
        this.removePopup(page);
    }

    private boolean addPopup(Page page) {
        if (page.getPopupType() == null) {
            return false;
        }
        this.addSatellitePage(page);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePopup(Page page) {
        String key = page.getUniqueKey();
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            int cnt = this.popup.size();
            for (int i = 0; i < cnt; ++i) {
                if (!this.popup.get(i).getUniqueKey().equals(key)) continue;
                this.popup.remove(i);
                Option.trace("removePopup %s", key);
                return;
            }
        }
        Option.trace("donot remove, not found %s", key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPopup() {
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            this.popup.clear();
            Option.traceWithStack("popup clear", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Page page) {
        if (page == null) {
            return;
        }
        if (this.addPopup(page = page.getParentPage())) {
            return;
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            Page old = null;
            if (cnt > 0) {
                old = this.getPage();
            }
            if (page.isHistoryClear()) {
                for (int i = 0; i < cnt; ++i) {
                    Page h = this.hist.get(i);
                    if (!page.equals(h)) continue;
                    for (int j = cnt - 1; j >= i; --j) {
                        this.hist.remove(j).setHistoryKey(0);
                    }
                    break;
                }
            }
            if (page.isAllowHistoryAdd()) {
                this.setInfo(page);
                this.hist.add(page);
                page.setHistoryKey(this.histry_no);
            }
            if ((cnt = this.getHistoryCount()) == 0 || old != this.getPage()) {
                if (cnt > 0 && old != null) {
                    Option.trace(String.format("old=%s(%s) / new=%s(%s)", old.getID().toString(), old.getUniqueKey(), this.getPage().getID().toString(), this.getPage().getUniqueKey()), new Object[0]);
                }
                this.clearPopup();
                this.initSatellitePage(this.getPage());
            }
        }
    }

    private void setInfo(Page page) {
        if (page.getPageServerInformation() != null) {
            return;
        }
        Page old = this.getPage();
        if (old == null) {
            return;
        }
        page.setPageServerInformation(old.getPageServerInformation());
    }

    public int getHistoryCount() {
        return this.hist.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page[] getAllPage(PageID id) {
        if (id == null) {
            return new Page[0];
        }
        ArrayList<Page> list = new ArrayList<Page>();
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = 0; i < cnt; ++i) {
                Page h = this.hist.get(i);
                if (!h.equals(id)) continue;
                int hld = list.size();
                boolean flag = true;
                for (int j = 0; j < hld; ++j) {
                    if (((Page)list.get(j)).getUniqueKey() != h.getUniqueKey()) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                list.add(h);
            }
        }
        return list.toArray(new Page[0]);
    }

    public Page getPage(PageID id) {
        Page[] p = this.getAllPage(id);
        if (p.length == 0) {
            return null;
        }
        return p[p.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page[] getBrowsingPage() {
        ArrayList<Page> list = new ArrayList<Page>();
        this.lock();
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            int cnt = this.popup.size();
            for (int i = 0; i < cnt; ++i) {
                list.add(this.popup.get(i));
            }
        }
        list.add(this.getPage());
        return list.toArray(new Page[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getBrowsingPage(String uni) {
        int i;
        int cnt;
        Option.trace("getBrowsingPage  %d >> %s", this.hashCode(), uni);
        Page page = null;
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            cnt = this.popup.size();
            for (i = 0; i < cnt; ++i) {
                page = this.popup.get(i);
                Option.trace("getBrowsingPage popup %d %s", this.hashCode(), page.getUniqueKey());
                if (!page.getUniqueKey().equals(uni)) continue;
                return page;
            }
        }
        arrayList = this.hist;
        synchronized (arrayList) {
            cnt = this.getHistoryCount();
            for (i = 0; i < cnt; ++i) {
                page = this.hist.get(i);
                Page hit = page.getBypassPage(uni);
                if (hit == null) continue;
                this.initSatellitePage(page);
                return hit;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(int last_no) {
        if (last_no < 0) {
            return;
        }
        if (last_no == 0) {
            this.clearPopup();
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = cnt - 1; i >= 0; --i) {
                if (last_no == 0) {
                    this.hist.remove(i).setHistoryKey(0);
                    return;
                }
                --last_no;
            }
        }
        if (last_no == 0) {
            this.initSatellitePage(this.getPage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(PageID page_id) {
        boolean init_f = false;
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = cnt - 1; i >= 0; --i) {
                Page page = this.hist.get(i);
                if (page.getID() != page_id) continue;
                this.hist.remove(i).setHistoryKey(0);
                if (i != cnt - 1) continue;
                this.clearPopup();
                init_f = true;
            }
        }
        if (init_f) {
            this.initSatellitePage(this.getPage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage() {
        this.clearPopup();
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = 0; i < cnt; ++i) {
                this.hist.get(i).setHistoryKey(0);
            }
            this.hist.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(int last_no) {
        if (last_no < 0) {
            return null;
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = cnt - 1; i >= 0; --i) {
                if (last_no == 0) {
                    return this.hist.get(i);
                }
                --last_no;
            }
        }
        return null;
    }

    public Page getPage() {
        return this.getPage(0);
    }
}

