package #1.#x;


/**
 * ページファクトリー。
 */
public class PageLoader extends paraselene.supervisor.PageFactory {
	private static PageLoader pf = null;

	/**
	 * コンストラクタ。
	 * 毎秒チェックを行い、各Pageインスタンスを事前に準備します。
	 * 各インスタンス数がstock_cntを下回ると、inc_cnt数追加します。
	 * @param stock_cnt 補充を開始する数。
	 * @param inc_cnt   10秒おきに補充する数。
	 */
	public PageLoader( int stock_cnt, int inc_cnt ) {
		super( stock_cnt, inc_cnt );
	}

	/**
	 * nullページ(遷移元が無い時のページ)の取得。
	 * @return nullページ。
	 */
	public paraselene.supervisor.NullPage getNullPage() {
		return new #1.DummyPage();
	}

	/**
	 * 初期化。
	 * @param stock_cnt 補充を開始する数。
	 * @param inc_cnt   10秒おきに補充する数。
	 */
	public static void init( int stock_cnt, int inc_cnt ) {
		pf = new PageLoader( stock_cnt, inc_cnt );
	}

	/**
	 * ページファクトリーの取得。
	 * @return ページファクトリー。
	 */
	public static paraselene.supervisor.PageFactory getPageFactory() {
		return pf;
	}

	/**
	 * 初期化失敗設定。
	 */
	void failInit() {
		teapot_f = true;
	}
}

